/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.utils;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.procedures.CrazyPhoneGetContactsProcedure;
import net.mcreator.crazythings.procedures.GetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.utils.PhoneConversationStorage;
import net.mcreator.crazythings.world.inventory.CrazyPhoneContactsScreenMenu;
import net.mcreator.crazythings.world.inventory.CrazyPhoneConversationMenu;
import net.mcreator.crazythings.world.inventory.CrazyPhoneMayorCandidateScreenMenu;
import net.mcreator.crazythings.world.inventory.CrazyPhoneMayorsCandidatesListMenu;
import net.mcreator.crazythings.world.inventory.CrazyPhonePasswordScreenMenu;
import net.mcreator.crazythings.world.inventory.CrazyPhonePictureFoldersScreenMenu;
import net.mcreator.crazythings.world.inventory.CrazyPhonePicturesScreenMenu;
import net.mcreator.crazythings.world.inventory.CrazyPhoneSignInScreenMenu;
import net.mcreator.crazythings.world.inventory.CrazyphoneHomeScreenMenu;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class ScreenMenuUtils {
    public static void openLastCrazyPhoneMenu(Player player, InteractionHand hand) {
        ScreenMenuUtils.popScreen(player);
        ScreenMenuUtils.openCurrentCrazyPhoneMenu(player, hand);
    }

    public static void openCurrentCrazyPhoneMenu(Player player, InteractionHand hand) {
        CrazythingsModVariables.PlayerVariables _vars = (CrazythingsModVariables.PlayerVariables)player.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        String tag = _vars.currentCrazyPhoneScreenOpened;
        if (tag == null || tag.isEmpty()) {
            return;
        }
        String screenId = ScreenMenuUtils.parseScreenIdFromTag(tag);
        String screenData = ScreenMenuUtils.parseScreenDataFromTag(tag);
        ScreenMenuUtils.openCrazyPhoneMenuByTag(player, hand, screenId, screenData);
    }

    public static String parseScreenIdFromTag(String tag) {
        int dotIndex = tag.indexOf(59);
        return dotIndex != -1 ? tag.substring(0, dotIndex) : tag;
    }

    public static String parseScreenDataFromTag(String tag) {
        int dotIndex = tag.indexOf(59);
        return dotIndex != -1 && dotIndex + 1 < tag.length() ? tag.substring(dotIndex + 1) : null;
    }

    public static void openCrazyPhoneMenuByTag(Player player, InteractionHand hand, String screenId, String screenData) {
        if (screenId == null || screenId.isEmpty()) {
            return;
        }
        switch (screenId) {
            case "crazythings:crazyphone_home_screen": {
                ScreenMenuUtils.openPhoneCustomMenu(player, hand, CrazyphoneHomeScreenMenu.class);
                break;
            }
            case "crazythings:crazy_phone_sign_in_screen": {
                ScreenMenuUtils.openPhoneCustomMenu(player, hand, CrazyPhoneSignInScreenMenu.class);
                break;
            }
            case "crazythings:crazy_phone_password_screen": {
                ScreenMenuUtils.openPhoneCustomMenu(player, hand, CrazyPhonePasswordScreenMenu.class);
                break;
            }
            case "crazythings:crazy_phone_picture_folders_screen": {
                ScreenMenuUtils.openPhoneCustomMenu(player, hand, CrazyPhonePictureFoldersScreenMenu.class);
                break;
            }
            case "crazythings:crazy_phone_pictures_screen": {
                ScreenMenuUtils.openPhoneAlbumMenuWithData(player, hand, screenData);
                break;
            }
            case "crazythings:crazy_phone_contacts_screen": {
                ScreenMenuUtils.openPhoneContactsMenu(player, hand);
                break;
            }
            case "crazythings:crazy_phone_conversation": {
                ScreenMenuUtils.openPhoneConversationMenu(player, hand, screenData);
                break;
            }
            case "crazythings:crazy_phone_mayors_candidates_list": {
                ScreenMenuUtils.openPhoneCustomMenu(player, hand, CrazyPhoneMayorsCandidatesListMenu.class);
                break;
            }
            default: {
                CrazythingsMod.LOGGER.warn("Unknown screen ID: " + screenId);
            }
        }
    }

    public static void popScreen(Player player) {
        String newCurrent;
        CrazythingsModVariables.PlayerVariables playerData = (CrazythingsModVariables.PlayerVariables)player.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        List<String> history = ScreenMenuUtils.getScreenHistory(playerData.crazyPhoneScreenHistory);
        if (history.size() <= 1) {
            return;
        }
        history.remove(history.size() - 1);
        playerData.currentCrazyPhoneScreenOpened = newCurrent = history.get(history.size() - 1);
        playerData.crazyPhoneScreenHistory = ScreenMenuUtils.serializeScreenHistory(history);
        player.setData(CrazythingsModVariables.PLAYER_VARIABLES, (Object)playerData);
    }

    public static void pushScreen(Player player, String screenId, String screenData) {
        CrazythingsModVariables.PlayerVariables playerData = (CrazythingsModVariables.PlayerVariables)player.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        String screenTag = screenData == null || screenData.isEmpty() ? screenId : screenId + ";" + screenData;
        List<String> history = ScreenMenuUtils.getScreenHistory(playerData.crazyPhoneScreenHistory);
        if (!history.isEmpty()) {
            String current = history.get(history.size() - 1);
            String currentId = ScreenMenuUtils.parseScreenIdFromTag(current);
            if (currentId.equals(screenId)) {
                history.set(history.size() - 1, screenTag);
                playerData.crazyPhoneScreenHistory = ScreenMenuUtils.serializeScreenHistory(history);
                playerData.currentCrazyPhoneScreenOpened = screenTag;
                player.setData(CrazythingsModVariables.PLAYER_VARIABLES, (Object)playerData);
                return;
            }
            if (current.equals(screenTag)) {
                return;
            }
        }
        history.add(screenTag);
        playerData.crazyPhoneScreenHistory = ScreenMenuUtils.serializeScreenHistory(history);
        playerData.currentCrazyPhoneScreenOpened = screenTag;
        player.setData(CrazythingsModVariables.PLAYER_VARIABLES, (Object)playerData);
    }

    public static void addDataToCurrentPage(Player player, String newScreenData) {
        CrazythingsModVariables.PlayerVariables playerData = (CrazythingsModVariables.PlayerVariables)player.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        List<String> history = ScreenMenuUtils.getScreenHistory(playerData.crazyPhoneScreenHistory);
        if (history.isEmpty()) {
            return;
        }
        String currentTag = history.get(history.size() - 1);
        String currentId = ScreenMenuUtils.parseScreenIdFromTag(currentTag);
        String newTag = newScreenData == null || newScreenData.isEmpty() ? currentId : currentId + ";" + newScreenData;
        history.set(history.size() - 1, newTag);
        playerData.crazyPhoneScreenHistory = ScreenMenuUtils.serializeScreenHistory(history);
        playerData.currentCrazyPhoneScreenOpened = newTag;
        player.setData(CrazythingsModVariables.PLAYER_VARIABLES, (Object)playerData);
    }

    public static void debugPrintScreenHistory(Player player) {
        CrazythingsModVariables.PlayerVariables playerData = (CrazythingsModVariables.PlayerVariables)player.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        String historyString = playerData.crazyPhoneScreenHistory;
        List<String> history = ScreenMenuUtils.getScreenHistory(historyString);
        System.out.println("=== CRAZY PHONE SCREEN HISTORY ===");
        for (int i = 0; i < history.size(); ++i) {
            System.out.println("[" + i + "] " + history.get(i));
        }
        System.out.println("Current screen: " + playerData.currentCrazyPhoneScreenOpened);
        System.out.println("==================================");
    }

    public static void resetToHomeScreen(Player player) {
        String homeScreen;
        CrazythingsModVariables.PlayerVariables playerData = (CrazythingsModVariables.PlayerVariables)player.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        playerData.crazyPhoneScreenHistory = homeScreen = "crazythings:crazyphone_home_screen";
        playerData.currentCrazyPhoneScreenOpened = homeScreen;
        player.setData(CrazythingsModVariables.PLAYER_VARIABLES, (Object)playerData);
    }

    public static List<String> getScreenHistory(String historyString) {
        if (historyString == null || historyString.isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(historyString.split("\\|")));
    }

    public static String serializeScreenHistory(List<String> history) {
        return String.join((CharSequence)"|", history);
    }

    private static void openPhoneAlbumMenuWithData(Player player, InteractionHand hand, String screenData) {
        if (screenData == null || screenData.isEmpty()) {
            System.err.println("Missing data for screen 'album'");
            return;
        }
        try {
            int data = Integer.parseInt(screenData);
            ScreenMenuUtils.openPhoneAlbumMenu(player, hand, data);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid number for screen 'album': " + screenData);
        }
    }

    public static void openPhoneCustomMenu(Player player, final InteractionHand hand, final Class<? extends AbstractContainerMenu> menuClass) {
        if (player instanceof ServerPlayer) {
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Crazy Phone");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(player.blockPosition());
                    packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    try {
                        return (AbstractContainerMenu)menuClass.getConstructor(Integer.TYPE, Inventory.class, FriendlyByteBuf.class).newInstance(id, inventory, packetBuffer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create menu instance", e);
                    }
                }
            }, buf -> {
                buf.writeBlockPos(player.blockPosition());
                buf.writeByte(0);
            });
        }
    }

    public static void openPhoneMayorCandidateMenu(Player player, final String candidateNumber) {
        if (player instanceof ServerPlayer) {
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Crazy Phone");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(player.blockPosition());
                    packetBuffer.writeByte(0);
                    packetBuffer.writeUtf(candidateNumber);
                    try {
                        System.err.println("OPEN MAGGLE");
                        return new CrazyPhoneMayorCandidateScreenMenu(id, inventory, packetBuffer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create menu instance", e);
                    }
                }
            }, buf -> {
                buf.writeBlockPos(player.blockPosition());
                buf.writeByte(0);
                buf.writeUtf(candidateNumber);
            });
        }
    }

    public static void openPhoneContactsMenu(Player player, final InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            String ownerNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)player, null);
            final ListTag contacts = CrazyPhoneGetContactsProcedure.execute((LevelAccessor)player.level(), ownerNumber);
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Crazy Phone");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    ScreenMenuUtils.populateBufferWithMenuData(packetBuffer, player, hand, contacts);
                    try {
                        return new CrazyPhoneContactsScreenMenu(id, inventory, packetBuffer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create menu instance", e);
                    }
                }
            }, buf -> ScreenMenuUtils.populateBufferWithMenuData((FriendlyByteBuf)buf, player, hand, contacts));
        }
    }

    private static void populateBufferWithMenuData(FriendlyByteBuf buf, Player player, InteractionHand hand, ListTag contacts) {
        buf.writeBlockPos(player.blockPosition());
        buf.writeByte(0);
        ScreenMenuUtils.serializeContactsToBuffer(buf, contacts);
    }

    private static void serializeContactsToBuffer(FriendlyByteBuf buf, ListTag contacts) {
        buf.writeInt(contacts.size());
        for (Tag contact : contacts) {
            if (!(contact instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)contact;
            ScreenMenuUtils.serializeContactDetails(buf, compoundTag);
        }
    }

    private static void serializeContactDetails(FriendlyByteBuf buf, CompoundTag contact) {
        String number = contact.getString("number");
        String name = contact.getString("name");
        String uuid = contact.contains("uuid", 8) ? contact.getString("uuid") : "";
        String skin = contact.contains("skin", 8) ? contact.getString("skin") : "";
        buf.writeUtf(number);
        buf.writeUtf(name);
        buf.writeUtf(uuid);
        buf.writeUtf(skin);
    }

    public static void openPhoneAlbumMenu(Player player, final InteractionHand hand, final int albumId) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"minecraft:item.book.page_turn"));
            if (sound != null) {
                serverPlayer.playNotifySound(sound, SoundSource.PLAYERS, 0.7f, 1.2f);
            }
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Crazy Phone");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(player.blockPosition());
                    packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    packetBuffer.writeInt(albumId);
                    try {
                        return new CrazyPhonePicturesScreenMenu(id, inventory, packetBuffer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create menu instance", e);
                    }
                }
            }, buf -> {
                buf.writeBlockPos(player.blockPosition());
                buf.writeByte(0);
                buf.writeInt(albumId);
            });
        }
    }

    public static void openPhoneConversationMenu(Player player, final InteractionHand hand, final String conversationId) {
        if (player instanceof ServerPlayer) {
            String playerNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)player, null);
            CrazythingsModVariables.MapVariables variables = CrazythingsModVariables.MapVariables.get((LevelAccessor)player.level());
            CompoundTag phonesTag = variables.phones;
            Tag phoneTag = phonesTag.get(playerNumber);
            if (phoneTag instanceof CompoundTag) {
                ListTag list;
                CompoundTag phoneCompoundTag = (CompoundTag)phoneTag;
                Tag tag = phoneCompoundTag.get("notifications");
                ListTag notifications = tag instanceof ListTag ? (list = (ListTag)tag) : new ListTag();
                ListTag updatedNotifications = new ListTag();
                for (Tag t : notifications) {
                    StringTag stringTag;
                    if (!(t instanceof StringTag) || (stringTag = (StringTag)t).getAsString().equals(conversationId)) continue;
                    updatedNotifications.add((Object)stringTag);
                }
                if (updatedNotifications.size() != notifications.size()) {
                    phoneCompoundTag.put("notifications", (Tag)updatedNotifications);
                    phonesTag.put(playerNumber, (Tag)phoneCompoundTag);
                    CrazythingsModVariables.MapVariables.get((LevelAccessor)player.level()).syncData((LevelAccessor)player.level());
                }
            }
            final RegistryAccess registryAccess = player.registryAccess();
            final ConnectionType connectionType = ConnectionType.NEOFORGE;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Crazy Phone");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    RegistryFriendlyByteBuf packetBuffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess, connectionType);
                    ScreenMenuUtils.populateBufferWithConversationData(packetBuffer, player, hand, conversationId);
                    try {
                        return new CrazyPhoneConversationMenu(id, inventory, packetBuffer);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create menu instance", e);
                    }
                }
            }, buf -> ScreenMenuUtils.populateBufferWithConversationData(buf, player, hand, conversationId));
        }
    }

    protected static void populateBufferWithConversationData(RegistryFriendlyByteBuf packetBuffer, Player player, InteractionHand hand, String conversationId) {
        ScreenMenuUtils.writePlayerAndConversationInfo(packetBuffer, player, conversationId);
        ScreenMenuUtils.writeParticipantsToBuffer(packetBuffer, player, conversationId);
        ScreenMenuUtils.writeMessagesToBuffer(packetBuffer, player, conversationId);
    }

    private static void writePlayerAndConversationInfo(RegistryFriendlyByteBuf buffer, Player player, String conversationId) {
        buffer.writeBlockPos(player.blockPosition());
        buffer.writeByte(0);
        buffer.writeUtf(conversationId);
    }

    private static void writeParticipantsToBuffer(RegistryFriendlyByteBuf buffer, Player player, String conversationId) {
        List<String> participantNumbers = CrazyPhoneHelper.getNumbersFromConversationId(conversationId);
        ArrayList<Contact> participants = new ArrayList<Contact>();
        for (String number : participantNumbers) {
            Contact contact = CrazyPhoneHelper.getContact(player.level(), number);
            if (contact == null) continue;
            participants.add(contact);
        }
        buffer.writeInt(participants.size());
        for (Contact contact : participants) {
            buffer.writeUtf(contact.name);
            buffer.writeUtf(contact.number);
            buffer.writeUtf(contact.uuid);
            buffer.writeUtf(contact.skin);
        }
    }

    private static void writeMessagesToBuffer(RegistryFriendlyByteBuf buffer, Player player, String conversationId) {
        List<CompoundTag> messages = PhoneConversationStorage.loadMessages(conversationId);
        ListTag listTag = new ListTag();
        for (CompoundTag message : messages) {
            listTag.add((Object)message);
        }
        buffer.writeNbt((Tag)listTag);
    }
}

