/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.utils.CrazyPhoneMessageParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber
public class PhoneConversationStorage {
    private static final String CONVERSATIONS_DIR = "crazyphone-conversations";
    private static final int MAX_MESSAGES_PER_CONVERSATION = 100;
    private static final Map<String, Object> conversationLocks = new ConcurrentHashMap<String, Object>();
    private static final Map<String, List<CompoundTag>> conversationCache = new ConcurrentHashMap<String, List<CompoundTag>>();

    private static Object getConversationLock(String conversationId) {
        return conversationLocks.computeIfAbsent(conversationId, k -> new Object());
    }

    public static List<CompoundTag> loadMessages(String conversationId) {
        List<CompoundTag> cached = conversationCache.get(conversationId);
        if (cached != null) {
            return new ArrayList<CompoundTag>(cached);
        }
        Path conversationPath = PhoneConversationStorage.getConversationPath(conversationId);
        ArrayList<CompoundTag> messages = new ArrayList<CompoundTag>();
        if (Files.exists(conversationPath, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(conversationPath);
                for (String line : lines) {
                    CompoundTag message = CrazyPhoneMessageParser.deserializeMessage(line);
                    if (message == null) continue;
                    messages.add(message);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        conversationCache.put(conversationId, new ArrayList(messages));
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveMessage(String conversationId, CompoundTag message) {
        Object lock;
        Object object = lock = PhoneConversationStorage.getConversationLock(conversationId);
        synchronized (object) {
            List<CompoundTag> messages = conversationCache.get(conversationId);
            messages = messages == null ? PhoneConversationStorage.loadMessages(conversationId) : new ArrayList<CompoundTag>(messages);
            for (CompoundTag existing : messages) {
                if (!existing.equals((Object)message)) continue;
                return false;
            }
            messages.add(message);
            while (messages.size() > 100) {
                messages.remove(0);
            }
            conversationCache.put(conversationId, new ArrayList<CompoundTag>(messages));
            PhoneConversationStorage.saveAllMessages(conversationId, messages);
            return true;
        }
    }

    public static void saveAllMessages(String conversationId, List<CompoundTag> messages) {
        Path conversationPath = PhoneConversationStorage.getConversationPath(conversationId);
        ArrayList<String> serialized = new ArrayList<String>(messages.size());
        for (CompoundTag message : messages) {
            serialized.add(CrazyPhoneMessageParser.serializeMessage(message));
        }
        try {
            Files.write(conversationPath, serialized, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            conversationCache.put(conversationId, new ArrayList<CompoundTag>(messages));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Path getConversationPath(String conversationId) {
        return Paths.get(CONVERSATIONS_DIR, conversationId + ".json");
    }

    private static void migrateOldMessageData(LevelAccessor level) {
        CompoundTag oldData = CrazythingsModVariables.MapVariables.get((LevelAccessor)level).crazyPhoneMessages;
        for (String conversationId : oldData.getAllKeys()) {
            ListTag messageList = oldData.getList(conversationId, 10);
            ArrayList<CompoundTag> messages = new ArrayList<CompoundTag>();
            for (int i = 0; i < messageList.size(); ++i) {
                messages.add(messageList.getCompound(i));
            }
            PhoneConversationStorage.saveAllMessages(conversationId, messages);
        }
        if (!oldData.isEmpty()) {
            CrazythingsModVariables.MapVariables.get((LevelAccessor)level).crazyPhoneMessages = new CompoundTag();
            System.out.println("[CrazyThings] Migration completed: old messages stored in /crazyphone-conversations folder");
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            PhoneConversationStorage.migrateOldMessageData(level);
        }
    }

    static {
        try {
            Files.createDirectories(Paths.get(CONVERSATIONS_DIR, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

