/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class LaserGameDataHelper {
    public static Vec3 getLaserGameBase(Entity entity) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        Vec3 vec = vars.laserGameBase;
        return vec;
    }

    public static void setLaserGameBase(Entity entity, Vec3 pos) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        vars.laserGameBase = pos;
    }

    public static double getLaserGameNbLives(Entity entity) {
        return LaserGameDataHelper.getPlayerVariables((Entity)entity).laserGameNbLives;
    }

    public static void setLaserGameNbLives(Entity entity, double lives) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        vars.laserGameNbLives = lives;
    }

    public static boolean isLaserGamePlaying(Entity entity) {
        return LaserGameDataHelper.getPlayerVariables((Entity)entity).laserGameIsPlaying;
    }

    public static void setLaserGameIsPlaying(Entity entity, boolean playing) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        vars.laserGameIsPlaying = playing;
    }

    public static ListTag getLaserGameShoots(Entity entity) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        ListTag shoots = vars.laserGameShoots;
        if (shoots == null) {
            vars.laserGameShoots = shoots = new ListTag();
        }
        return shoots;
    }

    public static void setLaserGameShoots(Entity entity, ListTag shoots) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        vars.laserGameShoots = shoots;
    }

    public static void addLaserGameShoot(Entity entity, String victimName) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        ListTag shoots = vars.laserGameShoots;
        if (shoots == null) {
            shoots = new ListTag();
        }
        shoots.add((Object)StringTag.valueOf((String)victimName));
        vars.laserGameShoots = shoots;
    }

    public static double getLaserGameNbShoots(Entity entity) {
        return LaserGameDataHelper.getPlayerVariables((Entity)entity).laserGameNbShoots;
    }

    public static void setLaserGameNbShoots(Entity entity, double nbShoots) {
        CrazythingsModVariables.PlayerVariables vars = LaserGameDataHelper.getPlayerVariables(entity);
        vars.laserGameNbShoots = nbShoots;
    }

    public static void incrementLaserGameNbShoots(Entity entity) {
        double nbShoots = LaserGameDataHelper.getLaserGameNbShoots(entity);
        LaserGameDataHelper.setLaserGameNbShoots(entity, nbShoots + 1.0);
    }

    public static void resetLaserGamePlayerData(Entity entity) {
        LaserGameDataHelper.setLaserGameShoots(entity, new ListTag());
        LaserGameDataHelper.setLaserGameNbShoots(entity, 0.0);
        LaserGameDataHelper.setLaserGameNbLives(entity, 0.0);
        LaserGameDataHelper.setLaserGameIsPlaying(entity, false);
        LaserGameDataHelper.setLaserGameBase(entity, Vec3.ZERO);
    }

    public static double getLaserGameNbMaxLives(LevelAccessor world) {
        CrazythingsModVariables.MapVariables mapVars = CrazythingsModVariables.MapVariables.get(world);
        return mapVars.laserGameNbMaxLives;
    }

    public static void setLaserGameNbMaxLives(LevelAccessor world, double maxLives) {
        CrazythingsModVariables.MapVariables mapVars = CrazythingsModVariables.MapVariables.get(world);
        mapVars.laserGameNbMaxLives = maxLives;
        mapVars.syncData(world);
    }

    public static Map<String, Integer> getSortedVictimHitMap(Player player) {
        ListTag shoots = LaserGameDataHelper.getLaserGameShoots((Entity)player);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Tag name : shoots) {
            if (!(name instanceof StringTag)) continue;
            StringTag nameString = (StringTag)name;
            countMap.put(nameString.toString(), countMap.getOrDefault(nameString.toString(), 0) + 1);
        }
        return countMap.entrySet().stream().sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static CrazythingsModVariables.PlayerVariables getPlayerVariables(Entity entity) {
        return (CrazythingsModVariables.PlayerVariables)entity.getData(CrazythingsModVariables.PLAYER_VARIABLES);
    }

    public static void sync(LevelAccessor world) {
        CrazythingsModVariables.MapVariables.get(world).syncData(world);
    }
}

