/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class CrazyPhoneMessageParser {
    private static final Gson gson = new Gson();

    public static String serializeMessage(CompoundTag message) {
        JsonObject json = new JsonObject();
        json.addProperty("sender", message.getString("sender"));
        json.addProperty("value", message.getString("value"));
        json.addProperty("timecode", (Number)message.getInt("timecode"));
        if (message.contains("image")) {
            CompoundTag image = message.getCompound("image");
            JsonObject imageJson = new JsonObject();
            imageJson.addProperty("image_id_most", (Number)image.getLong("image_id_most"));
            imageJson.addProperty("image_id_least", (Number)image.getLong("image_id_least"));
            imageJson.addProperty("image_time", (Number)image.getLong("image_time"));
            imageJson.addProperty("owner", image.getString("owner"));
            if (image.contains("biome")) {
                imageJson.addProperty("biome", image.getString("biome"));
            }
            json.add("image", (JsonElement)imageJson);
        }
        return gson.toJson((JsonElement)json);
    }

    public static CompoundTag deserializeMessage(String jsonLine) {
        JsonObject json = (JsonObject)gson.fromJson(jsonLine, JsonObject.class);
        CompoundTag tag = new CompoundTag();
        tag.putString("sender", json.get("sender").getAsString());
        tag.putString("value", json.get("value").getAsString());
        tag.putInt("timecode", json.get("timecode").getAsInt());
        if (json.has("image")) {
            JsonObject imageJson = json.getAsJsonObject("image");
            CompoundTag imageTag = new CompoundTag();
            imageTag.putLong("image_id_most", imageJson.get("image_id_most").getAsLong());
            imageTag.putLong("image_id_least", imageJson.get("image_id_least").getAsLong());
            imageTag.putLong("image_time", imageJson.get("image_time").getAsLong());
            imageTag.putString("owner", imageJson.get("owner").getAsString());
            if (imageJson.has("biome")) {
                imageTag.putString("biome", imageJson.get("biome").getAsString());
            }
            tag.put("image", (Tag)imageTag);
        }
        return tag;
    }
}

