/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.inventory.AlbumInventory;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.ImageItem;
import io.netty.buffer.ByteBuf;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mcreator.crazythings.client.gui.components.MessageData;
import net.mcreator.crazythings.item.CrazyPhoneItem;
import net.mcreator.crazythings.network.CrazyPhoneNewMessageNotificationPacket;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.procedures.CrazyPhoneAddContactToPhoneProcedure;
import net.mcreator.crazythings.procedures.CrazyPhoneGetContactsProcedure;
import net.mcreator.crazythings.procedures.GetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.PhoneConversationStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyPhoneHelper {
    public static void deleteSlotsFromAlbum(AlbumInventory inventory, Set<Integer> slots) {
        for (int slot : slots) {
            inventory.setItem(slot, ItemStack.EMPTY);
        }
    }

    public static void deleteSelectedAlbumSlotsFromHeldPhone(Player entity, Level world, Set<Integer> slots, Integer albumId) {
        IItemHandlerModifiable handler = CrazyPhoneHelper.getPhoneItemHandler(entity);
        ItemStack albumStack = CrazyPhoneHelper.getAlbumFromPhoneHandler(handler, albumId);
        if (!(albumStack.getItem() instanceof AlbumItem)) {
            return;
        }
        AlbumInventory inventory = new AlbumInventory((HolderLookup.Provider)world.registryAccess(), albumStack);
        CrazyPhoneHelper.deleteSlotsFromAlbum(inventory, slots);
        handler.setStackInSlot(albumId.intValue(), albumStack);
    }

    @Nullable
    public static IItemHandlerModifiable getPhoneItemHandler(Player player) {
        ItemStack held = player.getMainHandItem();
        if (!(held.getItem() instanceof CrazyPhoneItem)) {
            return null;
        }
        IItemHandler handler = (IItemHandler)held.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (!(handler instanceof IItemHandlerModifiable)) {
            return null;
        }
        IItemHandlerModifiable modifiableHandler = (IItemHandlerModifiable)handler;
        return modifiableHandler;
    }

    public static Contact getContact(Level world, String number) {
        Tag potentialContact = CrazythingsModVariables.MapVariables.get((LevelAccessor)world).phones.get(number);
        if (potentialContact != null && potentialContact instanceof CompoundTag) {
            String string;
            String string2;
            String string3;
            CompoundTag contactTag = (CompoundTag)potentialContact;
            Tag tag = contactTag.get("name");
            if (tag instanceof StringTag) {
                StringTag _stringTag = (StringTag)tag;
                string3 = _stringTag.getAsString();
            } else {
                string3 = "";
            }
            String name = string3;
            Tag tag2 = contactTag.get("uuid");
            if (tag2 instanceof StringTag) {
                StringTag _stringTag = (StringTag)tag2;
                string2 = _stringTag.getAsString();
            } else {
                string2 = "";
            }
            String uuid = string2;
            Tag tag3 = contactTag.get("skin");
            if (tag3 instanceof StringTag) {
                StringTag _stringTag = (StringTag)tag3;
                string = _stringTag.getAsString();
            } else {
                string = "";
            }
            String skin = string;
            return new Contact(number, name, skin, uuid);
        }
        return null;
    }

    public static ItemStack getAlbumFromPhoneHandler(IItemHandlerModifiable handler, int albumIndex) {
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        if (albumIndex < 0 || albumIndex >= handler.getSlots()) {
            return ItemStack.EMPTY;
        }
        return handler.getStackInSlot(albumIndex);
    }

    public static String getConversationNumber(String recipientNumber, Entity entity) {
        return CrazyPhoneHelper.getConversationNumber(Arrays.asList(recipientNumber, GetCrazyPhoneNumberFromMainHandProcedure.execute(entity, null)));
    }

    public static String getConversationNumber(String numberA, String numberB) {
        return CrazyPhoneHelper.getConversationNumber(Arrays.asList(numberA, numberA));
    }

    private static String getConversationNumber(List<String> numbers) {
        ArrayList<String> sorted = new ArrayList<String>(numbers);
        Collections.sort(sorted);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < sorted.size(); ++i) {
            result.append((String)sorted.get(i));
            if (i >= sorted.size() - 1) continue;
            result.append(".");
        }
        return result.toString();
    }

    public static List<String> getNumbersFromConversationId(String conversationId) {
        return Arrays.asList(conversationId.split("\\."));
    }

    public static ItemStack createContactHead(Contact contact) {
        ItemStack head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        String name = contact.getName() == null ? "Inconnu" : contact.getName();
        String number = contact.getNumber() == null ? "" : contact.getNumber();
        MutableComponent displayName = Component.literal((String)name).append(" \u2022 ").append((Component)Component.literal((String)number).withStyle(ChatFormatting.GRAY));
        head.set(DataComponents.CUSTOM_NAME, (Object)displayName);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)head, tag -> tag.putString("number", contact.getNumber()));
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)head, tag -> tag.putString("name", contact.getName()));
        if (contact.getUuid() != null && !contact.getUuid().isEmpty()) {
            try {
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)head, tag -> tag.putString("uuid", contact.getUuid()));
                GameProfile profile = new GameProfile(UUID.fromString(contact.getUuid()), "CustomHead");
                PropertyMap properties = profile.getProperties();
                if (contact.getSkin() != null || !contact.getSkin().isEmpty()) {
                    properties.put((Object)"textures", (Object)new Property("textures", contact.getSkin()));
                }
                ResolvableProfile resolvableProfile = new ResolvableProfile(profile);
                head.set(DataComponents.PROFILE, (Object)resolvableProfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return head;
    }

    public static void addMessage(Level world, String conversationId, String senderNumber, String message, int timestampInMinutes, @Nullable ItemStack image) {
        List<CompoundTag> conversation = PhoneConversationStorage.loadMessages(conversationId);
        CompoundTag messageTag = CrazyPhoneHelper.createMessageTag(senderNumber, message, timestampInMinutes, image);
        if (PhoneConversationStorage.saveMessage(conversationId, messageTag)) {
            List<String> numbers = CrazyPhoneHelper.getNumbersFromConversationId(conversationId);
            CrazyPhoneHelper.notifyContacts(world, messageTag, numbers, senderNumber, message, timestampInMinutes, conversationId);
        }
    }

    private static CompoundTag createMessageTag(String senderNumber, String message, int timestampInMinutes, @Nullable ItemStack image) {
        CompoundTag tag = new CompoundTag();
        tag.putString("sender", senderNumber);
        tag.putString("value", message);
        tag.putInt("timecode", timestampInMinutes);
        if (image != null && !image.isEmpty() && image.getItem() instanceof ImageItem && image.has((Supplier)Main.IMAGE_DATA_COMPONENT)) {
            ImageData imageData = (ImageData)image.get((Supplier)Main.IMAGE_DATA_COMPONENT);
            CompoundTag data = CrazyPhoneHelper.imageDataToCompoundTag(imageData);
            tag.put("image", (Tag)data);
        }
        return tag;
    }

    public static CompoundTag imageDataToCompoundTag(ImageData data) {
        List entities;
        CompoundTag tag = new CompoundTag();
        tag.putLong("image_id_most", data.getId().getMostSignificantBits());
        tag.putLong("image_id_least", data.getId().getLeastSignificantBits());
        tag.putLong("image_time", data.getTime());
        tag.putString("owner", data.getOwner());
        if (data.getBiome() != null) {
            tag.putString("biome", data.getBiome().toString());
        }
        if ((entities = data.getEntities()) != null && !entities.isEmpty()) {
            ListTag entityListTag = new ListTag();
            for (ResourceLocation entityID : entities) {
                entityListTag.add((Object)StringTag.valueOf((String)entityID.toString()));
            }
            tag.put("entities", (Tag)entityListTag);
        }
        return tag;
    }

    public static void notifyContacts(Level world, CompoundTag messageTag, List<String> numbers, String senderNumber, String message, int timestampInMinutes, String conversationId) {
        Contact sender = CrazyPhoneHelper.getContact(world, senderNumber);
        MinecraftServer server = world.getServer();
        if (sender == null || server == null) {
            return;
        }
        for (String receiverNumber : numbers) {
            Contact receiver;
            if (receiverNumber.equals(senderNumber) || (receiver = CrazyPhoneHelper.getContact(world, receiverNumber)) == null || receiver.getUuid() == null) continue;
            ServerPlayer receiverPlayer = server.getPlayerList().getPlayer(UUID.fromString(receiver.getUuid()));
            if (receiverPlayer != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)receiverPlayer, (CustomPacketPayload)new CrazyPhoneNewMessageNotificationPacket(messageTag, sender.getName()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            CrazythingsModVariables.MapVariables variables = CrazythingsModVariables.MapVariables.get((LevelAccessor)world);
            CompoundTag phonesTag = variables.phones;
            Tag receiverPhone = phonesTag.get(receiverNumber);
            if (receiverPhone instanceof CompoundTag) {
                ListTag listTag;
                CompoundTag receiverPhoneCompoundTag = (CompoundTag)receiverPhone;
                Tag notificationstag = receiverPhoneCompoundTag.get("notifications");
                ListTag notifications = notificationstag instanceof ListTag ? (listTag = (ListTag)notificationstag) : new ListTag();
                boolean alreadyExists = false;
                for (Tag tag : notifications) {
                    StringTag stringTag;
                    if (!(tag instanceof StringTag) || !(stringTag = (StringTag)tag).getAsString().equals(conversationId)) continue;
                    alreadyExists = true;
                    break;
                }
                if (!alreadyExists) {
                    notifications.add((Object)StringTag.valueOf((String)conversationId));
                    receiverPhoneCompoundTag.put("notifications", (Tag)notifications);
                    phonesTag.put(receiverNumber, (Tag)receiverPhoneCompoundTag);
                    variables.setDirty(true);
                }
            }
            CrazythingsModVariables.MapVariables.get((LevelAccessor)world).syncData((LevelAccessor)world);
            ListTag contactsOfReceiver = CrazyPhoneGetContactsProcedure.execute((LevelAccessor)world, receiverNumber);
            boolean hasContact = false;
            for (Tag contact : contactsOfReceiver) {
                CompoundTag compoundTag;
                if (!(contact instanceof CompoundTag) || !senderNumber.equals((compoundTag = (CompoundTag)contact).getString("number"))) continue;
                hasContact = true;
                break;
            }
            if (hasContact) continue;
            CrazyPhoneAddContactToPhoneProcedure.execute((LevelAccessor)world, senderNumber, receiverNumber);
        }
    }

    public static List<MessageData> getMessagesFromBuf(RegistryFriendlyByteBuf buffer) {
        ArrayList<MessageData> messageDatas = new ArrayList<MessageData>();
        Tag rawTag = RegistryFriendlyByteBuf.readNbt((ByteBuf)buffer, (NbtAccounter)NbtAccounter.create((long)0x200000L));
        if (!(rawTag instanceof ListTag)) {
            return messageDatas;
        }
        ListTag listTag = (ListTag)rawTag;
        for (Tag entry : listTag) {
            CompoundTag messageTag;
            MessageData data;
            if (!(entry instanceof CompoundTag) || (data = CrazyPhoneHelper.getMessageFromTag(messageTag = (CompoundTag)entry)) == null) continue;
            messageDatas.add(data);
        }
        return messageDatas;
    }

    @Nullable
    public static MessageData getMessageFromTag(CompoundTag messageTag) {
        CompoundTag imageTag;
        ImageData imageData;
        if (messageTag == null) {
            return null;
        }
        String value = messageTag.getString("value");
        String sender = messageTag.getString("sender");
        int timecode = messageTag.getInt("timecode");
        ItemStack stack = ItemStack.EMPTY;
        if (messageTag.contains("image", 10) && (imageData = ImageData.fromImageTag((CompoundTag)(imageTag = messageTag.getCompound("image")))) != null) {
            stack = new ItemStack((ItemLike)Main.IMAGE.get());
            imageData.addToImage(stack);
        }
        return new MessageData(timecode, value, sender, stack);
    }

    public static List<Contact> getContactsFromBuf(FriendlyByteBuf buffer) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        if (buffer.readableBytes() <= 0) {
            return contacts;
        }
        int contactsCount = buffer.readInt();
        for (int i = 0; i < contactsCount; ++i) {
            String name = buffer.readUtf();
            String number = buffer.readUtf();
            String uuid = buffer.readUtf();
            String skin = buffer.readUtf();
            contacts.add(new Contact(number, name, skin, uuid));
        }
        return contacts;
    }

    private static JsonObject readJsonFromUrl(URL url) {
        JsonObject jsonObject;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        InputStreamReader reader = new InputStreamReader(connection.getInputStream());
        try {
            jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        reader.close();
        return jsonObject;
    }

    public static GameProfile applySkinToProfile(GameProfile profile, String uuid) {
        try {
            URL skinUrl = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            JsonObject skinResponse = CrazyPhoneHelper.readJsonFromUrl(skinUrl);
            if (skinResponse == null || !skinResponse.has("properties")) {
                return null;
            }
            JsonArray properties = skinResponse.getAsJsonArray("properties");
            for (JsonElement element : properties) {
                JsonObject property = element.getAsJsonObject();
                String name = property.get("name").getAsString();
                String value = property.get("value").getAsString();
                String signature = property.has("signature") ? property.get("signature").getAsString() : null;
                profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
            }
            return profile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return profile;
        }
    }

    public static void takeSelectedAlbumSlotsFromHeldPhone(Player entity, Level world, Set<Integer> slotsToCopy, int albumId) {
        IItemHandlerModifiable handler = CrazyPhoneHelper.getPhoneItemHandler(entity);
        if (handler == null) {
            return;
        }
        ItemStack albumStack = CrazyPhoneHelper.getAlbumFromPhoneHandler(handler, albumId).copy();
        if (!(albumStack.getItem() instanceof AlbumItem)) {
            return;
        }
        AlbumInventory inventory = new AlbumInventory((HolderLookup.Provider)world.registryAccess(), albumStack);
        for (int slot : slotsToCopy) {
            boolean added;
            ItemStack itemToCopy = inventory.getItem(slot).copy();
            if (itemToCopy.isEmpty() || (added = entity.getInventory().add(itemToCopy)) || world.isClientSide()) continue;
            entity.drop(itemToCopy, false);
        }
    }

    public static void sendSelectedAlbumSlotsFromHeldPhone(Player entity, Level world, Set<Integer> selectedSlots, int albumId, String conversationId) {
        IItemHandlerModifiable handler = CrazyPhoneHelper.getPhoneItemHandler(entity);
        if (handler == null) {
            return;
        }
        ItemStack albumStack = CrazyPhoneHelper.getAlbumFromPhoneHandler(handler, albumId).copy();
        if (!(albumStack.getItem() instanceof AlbumItem)) {
            return;
        }
        String senderNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)entity, null);
        AlbumInventory inventory = new AlbumInventory((HolderLookup.Provider)world.registryAccess(), albumStack);
        int timestampInMinutes = (int)(Instant.now().getEpochSecond() / 60L);
        for (int slot : selectedSlots) {
            ItemStack imageToSend = inventory.getItem(slot).copy();
            if (imageToSend.isEmpty()) continue;
            CrazyPhoneHelper.addMessage(world, conversationId, senderNumber, "", timestampInMinutes, imageToSend);
        }
        CrazythingsModVariables.MapVariables.get((LevelAccessor)world).syncData((LevelAccessor)world);
    }
}

