/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.utils;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.AlbumScreen;
import de.maxhenkel.camera.inventory.AlbumInventory;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.CameraItem;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.mcreator.crazythings.client.gui.CrazyPhoneAlbumScreen;
import net.mcreator.crazythings.client.gui.CrazyPhoneImageScreen;
import net.mcreator.crazythings.item.CrazyPhoneItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CameraModHelper {
    public static boolean isSupportedCamera(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItem() instanceof CameraItem || stack.getItem() instanceof CrazyPhoneItem;
    }

    public static boolean isActive(ItemStack stack) {
        return ((CameraItem)Main.CAMERA.get()).isActive(stack);
    }

    public static void openAlbum(Player player, ItemStack album, int startIndex) {
        List images;
        if (player.level().isClientSide && !(images = ((AlbumItem)Main.ALBUM.get()).getImages((HolderLookup.Provider)player.level().registryAccess(), album)).isEmpty()) {
            CameraModHelper.openClientGui(images, startIndex);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openClientGui(List<UUID> images, int startIndex) {
        Minecraft mc = Minecraft.getInstance();
        CrazyPhoneAlbumScreen screen = new CrazyPhoneAlbumScreen(images);
        mc.setScreen((Screen)screen);
        mc.execute(() -> {
            Screen patt0$temp = mc.screen;
            if (patt0$temp instanceof AlbumScreen) {
                AlbumScreen s = (AlbumScreen)patt0$temp;
                try {
                    Method method = AlbumScreen.class.getDeclaredMethod("setIndex", Integer.TYPE);
                    method.setAccessible(true);
                    method.invoke((Object)s, startIndex);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openImage(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new CrazyPhoneImageScreen(stack));
    }

    public static boolean tryInsertImageIntoCrazyPhone(ServerPlayer player, ItemStack imageStack) {
        ItemStack held = player.getMainHandItem();
        if (!(held.getItem() instanceof CrazyPhoneItem)) {
            return false;
        }
        Object object = held.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (!(object instanceof IItemHandlerModifiable)) {
            return false;
        }
        IItemHandlerModifiable handler = (IItemHandlerModifiable)object;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack slotStack = handler.getStackInSlot(slot);
            if (slotStack.isEmpty() || !(slotStack.getItem() instanceof AlbumItem)) {
                ItemStack newAlbum = new ItemStack((ItemLike)Main.ALBUM.get());
                if (!CameraModHelper.tryAddImageToAlbum(player, newAlbum, imageStack)) continue;
                handler.setStackInSlot(slot, newAlbum);
                CameraModHelper.sendUpdate(player, held);
                return true;
            }
            if (!(slotStack.getItem() instanceof AlbumItem) || !CameraModHelper.tryAddImageToAlbum(player, slotStack, imageStack)) continue;
            handler.setStackInSlot(slot, slotStack);
            CameraModHelper.sendUpdate(player, held);
            return true;
        }
        return false;
    }

    private static void sendUpdate(ServerPlayer player, ItemStack held) {
    }

    private static boolean tryAddImageToAlbum(ServerPlayer player, ItemStack albumStack, ItemStack imageStack) {
        AlbumInventory inventory = new AlbumInventory((HolderLookup.Provider)player.level().registryAccess(), albumStack);
        for (int i = 0; i < 48; ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            inventory.setItem(i, imageStack.copy());
            return true;
        }
        return false;
    }
}

