/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.procedures.ResetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class VoteForMayorProcedure {
    public static InteractionResult execute(LevelAccessor world, CommandContext<CommandSourceStack> arguments, Entity entity) {
        long lastVoteTime;
        long l;
        if (entity == null || world.isClientSide()) {
            return InteractionResult.PASS;
        }
        String numberStr = new DecimalFormat("###").format(Math.round(DoubleArgumentType.getDouble(arguments, (String)"phoneNumber")));
        String myNumber = ResetCrazyPhoneNumberFromMainHandProcedure.execute(entity);
        if (myNumber.isEmpty() || numberStr.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (world instanceof Level) {
            Level level = (Level)world;
            l = level.getGameTime();
        } else {
            l = 0L;
        }
        long currentTime = l;
        CompoundTag voteTimestamps = CrazythingsModVariables.MapVariables.get((LevelAccessor)world).lastMayorVoteTimestamps;
        if (voteTimestamps.contains(myNumber) && currentTime - (lastVoteTime = voteTimestamps.getLong(myNumber)) < 600L) {
            Player _player;
            if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
                long remainingSeconds = (600L - (currentTime - lastVoteTime)) / 20L;
                _player.displayClientMessage((Component)Component.literal((String)("\u23f1 Vous devez attendre encore " + remainingSeconds + " seconde(s) avant de revoter.")).withStyle(ChatFormatting.RED), false);
                world.playSound(_player, _player.getOnPos(), SoundEvents.VILLAGER_NO, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.FAIL;
        }
        if (CrazythingsModVariables.MapVariables.get((LevelAccessor)world).mayorsCandidates.get(numberStr) == null) {
            Player _player;
            if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
                _player.displayClientMessage((Component)Component.literal((String)"Candidat introuvable !").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
                world.playSound(_player, _player.getOnPos(), SoundEvents.VILLAGER_NO, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.PASS;
        }
        boolean isNewVote = CrazythingsModVariables.MapVariables.get((LevelAccessor)world).mayorVotes.get(myNumber) == null;
        Contact contact = CrazyPhoneHelper.getContact((Level)world, myNumber);
        String playerName = contact != null ? contact.getName() : "Inconnu";
        MutableComponent broadcastMessage = isNewVote ? Component.literal((String)"\ud83d\uddf3 ").append((Component)Component.literal((String)playerName).withStyle(ChatFormatting.GOLD)).append(" a vot\u00e9 !") : Component.literal((String)"\ud83d\udd04 ").append((Component)Component.literal((String)playerName).withStyle(ChatFormatting.YELLOW)).append(" a chang\u00e9 d'avis et a vot\u00e9 pour quelqu'un d'autre !");
        world.getServer().getPlayerList().broadcastSystemMessage((Component)broadcastMessage.withStyle(ChatFormatting.AQUA), false);
        CrazythingsModVariables.MapVariables.get((LevelAccessor)world).mayorVotes.put(myNumber, (Tag)StringTag.valueOf((String)numberStr));
        voteTimestamps.putLong(myNumber, currentTime);
        CrazythingsModVariables.MapVariables.get(world).syncData(world);
        if (entity instanceof ServerPlayer) {
            ServerPlayer _player = (ServerPlayer)entity;
            _player.displayClientMessage((Component)Component.literal((String)"Vote enregistr\u00e9 avec succ\u00e8s !").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), false);
            world.playSound((Player)_player, _player.getOnPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
            _player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }
}

