/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SmokeStickItemInHandTickProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, ItemStack itemstack, Entity entity) {
        if (entity == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("isOn")) {
            boolean isMainHand = itemstack == livingEntity.getMainHandItem();
            Vec3 armPos = entity.position();
            if (isMainHand) {
                armPos = entity.position().add(SmokeStickItemInHandTickProcedure.getArmOffset(entity, false)).add(new Vec3(entity.getLookAngle().x * 0.25, 0.0, entity.getLookAngle().z * 0.25));
            }
            DustParticleOptions redDust = new DustParticleOptions(new Vector3f(1.0f, 0.3f, 0.3f), 1.0f);
            DustParticleOptions bigDust = new DustParticleOptions(new Vector3f(1.0f, 0.3f, 0.3f), 3.0f);
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)bigDust, armPos.x, armPos.y + 0.5, armPos.z, 0, (Math.random() - 0.5) * 0.2, 1.0, (Math.random() - 0.5) * 0.2, 0.5);
                _level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, armPos.x, armPos.y, armPos.z, 0, (Math.random() - 0.5) * 0.2, 0.5, (Math.random() - 0.5) * 0.2, 0.1);
                _level.sendParticles((ParticleOptions)redDust, armPos.x, armPos.y, armPos.z, 10, 0.05, 0.1, 0.05, 0.02);
                _level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, armPos.x, armPos.y, armPos.z, 0, 0.0, 0.0, 0.0, 0.02);
            }
        }
    }

    private static Vec3 getArmOffset(Entity entity, boolean rightArm) {
        float sideOffset = rightArm ? 0.4f : -0.4f;
        float forwardOffset = 0.2f;
        float heightOffset = 1.2f;
        float yawRad = (float)Math.toRadians(entity.getYRot());
        double dx = -Math.sin(yawRad) * (double)forwardOffset + Math.cos(yawRad) * (double)sideOffset;
        double dz = Math.cos(yawRad) * (double)forwardOffset + Math.sin(yawRad) * (double)sideOffset;
        return new Vec3(dx, (double)heightOffset, dz);
    }
}

