/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import javax.annotation.Nullable;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.init.CrazythingsModEntities;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.w3c.dom.events.Event;

@EventBusSubscriber(value={Dist.CLIENT})
public class ShootTntProjectileProcedure {
    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getHand() != event.getEntity().getUsedItemHand()) {
            return;
        }
        Player player = event.getEntity();
        Entity ridden = player.getVehicle();
        if (ridden == null || ridden.getType() != CrazythingsModEntities.TANK.get()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ShootTntProjectileMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Entity entity = event.getExplosion().getDirectSourceEntity();
        if (!(entity instanceof PrimedTnt)) {
            return;
        }
        PrimedTnt tnt = (PrimedTnt)entity;
        LivingEntity livingEntity = tnt.getOwner();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Entity ridden = player.getVehicle();
        if (ridden == null || ridden.getType() != CrazythingsModEntities.TANK.get()) {
            return;
        }
        event.getAffectedBlocks().clear();
    }

    public static void execute() {
        ShootTntProjectileProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }

    public static void executeFromServer(ServerPlayer serverPlayer) {
        Entity ridden = serverPlayer.getVehicle();
        if (ridden == null) {
            return;
        }
        if (ridden.getType() != CrazythingsModEntities.TANK.get()) {
            return;
        }
        Level level = serverPlayer.level();
        if (level.isClientSide()) {
            return;
        }
        Vec3 lookVec = ridden.getLookAngle().normalize();
        Vec3 spawnPos = ridden.position().add(lookVec.scale(1.5)).add(0.0, 1.5, 0.0);
        PrimedTnt tnt = new PrimedTnt(level, spawnPos.x, spawnPos.y, spawnPos.z, (LivingEntity)serverPlayer);
        tnt.setDeltaMovement(lookVec.scale(2.0));
        level.addFreshEntity((Entity)tnt);
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public record ShootTntProjectileMessage() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ShootTntProjectileMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"procedure_shoot_tnt_projectile"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShootTntProjectileMessage> STREAM_CODEC = StreamCodec.of((buf, message) -> {}, buf -> new ShootTntProjectileMessage());

        public CustomPacketPayload.Type<ShootTntProjectileMessage> type() {
            return TYPE;
        }

        public static void handleData(ShootTntProjectileMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.SERVERBOUND) {
                context.enqueueWork(() -> {
                    ServerPlayer player = (ServerPlayer)context.player();
                    if (!player.level().hasChunkAt(player.blockPosition())) {
                        return;
                    }
                    ShootTntProjectileProcedure.executeFromServer(player);
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)("Packet error: " + e.getMessage())));
                    return null;
                });
            }
        }

        @SubscribeEvent
        public static void registerMessage(FMLCommonSetupEvent event) {
            CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, ShootTntProjectileMessage::handleData);
        }
    }
}

