/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import java.util.Comparator;
import java.util.List;
import net.mcreator.crazythings.init.CrazythingsModSounds;
import net.mcreator.crazythings.utils.TickScheduler;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RootAndStareProcedure {
    public static void execute(LivingEntity source) {
        Vec3 sourcePos;
        AABB area;
        if (source == null || source.level().isClientSide) {
            return;
        }
        Level level = source.level();
        List targets = level.getEntitiesOfClass(LivingEntity.class, area = new AABB(sourcePos = source.position(), sourcePos).inflate(6.0), p -> p.getUUID() != source.getUUID() && !p.isSpectator() && p.isAlive());
        if (targets.isEmpty()) {
            return;
        }
        LivingEntity victim = targets.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)source))).orElse(null);
        if (victim == null) {
            return;
        }
        Vec3 victimPos = victim.position();
        float victimYaw = victim.getYRot();
        double distance = 1.0;
        double radians = Math.toRadians(victimYaw);
        double offsetX = Math.sin(radians) * distance;
        double offsetZ = -Math.cos(radians) * distance;
        double targetX = victimPos.x + offsetX;
        double targetY = victimPos.y;
        double targetZ = victimPos.z + offsetZ;
        source.teleportTo(targetX, targetY, targetZ);
        source.setYRot(victimYaw + 180.0f);
        source.setXRot(0.0f);
        source.yBodyRot = source.getYRot();
        source.lookAt(EntityAnchorArgument.Anchor.EYES, victim.getEyePosition());
        victim.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 120, 0));
        victim.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 0));
        victim.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 4));
        victim.addEffect(new MobEffectInstance(MobEffects.JUMP, 120, 250));
        Vec3 fixedPos = victim.position();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TickScheduler.schedule(level, 5, () -> {}, () -> {
                SoundEvent screamSound = (SoundEvent)CrazythingsModSounds.MONSTRE_SCREAMER.get();
                BlockPos pos = victim.blockPosition();
                serverLevel.playSound(null, pos, screamSound, SoundSource.HOSTILE, 2.5f, 1.0f);
            });
        }
        TickScheduler.schedule(level, 120, () -> {
            if (!source.isAlive() || !victim.isAlive()) {
                return;
            }
            victim.teleportTo(fixedPos.x, fixedPos.y, fixedPos.z);
            if (victim instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)victim;
                serverPlayer.lookAt(EntityAnchorArgument.Anchor.EYES, source.getEyePosition());
            } else if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                victim.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, victim.position(), victim.getRotationVector(), serverLevel, 4, victim.getName().getString(), victim.getDisplayName(), level.getServer(), (Entity)victim), "execute as " + victim.getStringUUID() + " at @s run tp @s ~ ~ ~ facing entity " + source.getStringUUID());
            }
            if (level instanceof ServerLevel) {
                SoundEvent ambientSound;
                ServerLevel serverLevel = (ServerLevel)level;
                if (Math.random() < 0.3 && (ambientSound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ambient.soul_sand_valley.additions"))) != null) {
                    serverLevel.playSound(null, victim.blockPosition(), ambientSound, SoundSource.AMBIENT, 1.0f, 1.0f);
                }
            }
        }, () -> {});
    }
}

