/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import java.util.Comparator;
import java.util.List;
import net.mcreator.crazythings.init.CrazythingsModSounds;
import net.mcreator.crazythings.utils.TickScheduler;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PullAndStareProcedure {
    private static Vec3 getFacingDirection(LivingEntity entity) {
        float yaw = entity.yBodyRot;
        float rad = (float)Math.toRadians(yaw);
        return new Vec3((double)(-Mth.sin((float)rad)), 0.0, (double)Mth.cos((float)rad)).normalize();
    }

    public static void execute(LivingEntity source) {
        if (source == null || source.level().isClientSide) {
            return;
        }
        Level level = source.level();
        Vec3 direction = PullAndStareProcedure.getFacingDirection(source);
        Vec3 front = source.position().add(direction.scale(1.0));
        AABB area = new AABB(front, front).inflate(4.0);
        List targets = level.getEntitiesOfClass(LivingEntity.class, area, p -> p.getUUID() != source.getUUID() && !p.isSpectator() && p.isAlive());
        if (targets.isEmpty()) {
            return;
        }
        LivingEntity victim = targets.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)source))).orElse(null);
        if (victim == null) {
            return;
        }
        victim.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, 0));
        victim.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
        victim.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 0));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = victim.blockPosition();
            SoundEvent sound = (SoundEvent)CrazythingsModSounds.MONSTER_SCREAMING.get();
            serverLevel.playSound(null, pos, sound, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        TickScheduler.schedule(level, 200, () -> {
            if (!source.isAlive() || !victim.isAlive()) {
                return;
            }
            Vec3 dir = PullAndStareProcedure.getFacingDirection(source);
            Vec3 pos = source.position().add(dir.scale(2.0)).add(0.0, 1.3, 0.0);
            victim.teleportTo(pos.x, pos.y, pos.z);
            victim.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, victim.position(), victim.getRotationVector(), level instanceof ServerLevel ? (ServerLevel)level : null, 4, victim.getName().getString(), victim.getDisplayName(), level.getServer(), (Entity)victim), "execute as " + victim.getStringUUID() + " at @s run tp @s ~ ~ ~ facing entity " + source.getStringUUID());
            if (victim instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)victim;
                serverPlayer.lookAt(EntityAnchorArgument.Anchor.EYES, source.getEyePosition());
            }
            if (level instanceof ServerLevel) {
                SoundEvent ambientSound;
                ServerLevel serverLevel = (ServerLevel)level;
                if (Math.random() < 0.5 && (ambientSound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ambient.soul_sand_valley.mood"))) != null) {
                    serverLevel.playSound(null, victim.blockPosition(), ambientSound, SoundSource.AMBIENT, 1.0f, 1.0f);
                }
            }
        }, () -> victim.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0)));
    }
}

