/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;

public class PrintFinalGPPositionsProcedure {
    private static final List<String> TEAM_NAMES = List.of("white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink");

    public static void execute(LevelAccessor world) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        PrintFinalGPPositionsProcedure.sendFinalRanking(level);
    }

    public static void sendFinalRanking(Level level) {
        Scoreboard scoreboard = level.getScoreboard();
        Objective lapsObjective = scoreboard.getObjective("laps");
        Objective checkpointsObjective = scoreboard.getObjective("checkpoints");
        Objective timerObjective = scoreboard.getObjective("race_timer");
        if (lapsObjective == null || checkpointsObjective == null || timerObjective == null) {
            return;
        }
        class TeamData {
            Component displayNameComponent;
            int laps;
            int checkpoints;
            int timeTicks;

            TeamData(Component displayNameComponent, int laps, int checkpoints, int timeTicks) {
                this.displayNameComponent = displayNameComponent;
                this.laps = laps;
                this.checkpoints = checkpoints;
                this.timeTicks = timeTicks;
            }
        }
        ArrayList<TeamData> finishers = new ArrayList<TeamData>();
        ArrayList<TeamData> nonFinishers = new ArrayList<TeamData>();
        for (String teamName : TEAM_NAMES) {
            PlayerTeam team = scoreboard.getPlayerTeam(teamName);
            if (team == null) continue;
            int laps = PrintFinalGPPositionsProcedure.getPlayerScore(scoreboard, teamName, lapsObjective);
            int checkpoints = PrintFinalGPPositionsProcedure.getPlayerScore(scoreboard, teamName, checkpointsObjective);
            int timeTicks = PrintFinalGPPositionsProcedure.getPlayerScore(scoreboard, teamName, timerObjective);
            MutableComponent displayNameComponent = team.getFormattedDisplayName();
            TeamData teamData = new TeamData((Component)displayNameComponent, laps, checkpoints, timeTicks);
            if (laps >= 5) {
                finishers.add(teamData);
                continue;
            }
            nonFinishers.add(teamData);
        }
        finishers.sort(Comparator.comparingInt(t -> t.timeTicks));
        nonFinishers.sort(Comparator.comparingInt(t -> t.laps).reversed().thenComparing(Comparator.comparingInt(t -> t.checkpoints).reversed()).thenComparingInt(t -> t.timeTicks));
        ArrayList<TeamData> sortedTeams = new ArrayList<TeamData>();
        sortedTeams.addAll(finishers);
        sortedTeams.addAll(nonFinishers);
        for (Player player : level.players()) {
            PlayerTeam playerTeam = scoreboard.getPlayerTeam(player.getScoreboardName());
            boolean isInTeam = false;
            if (playerTeam != null) {
                String teamName = playerTeam.getName();
                isInTeam = TEAM_NAMES.contains(teamName);
            }
            boolean isOp = player.hasPermissions(2);
            if (!isInTeam && !isOp) continue;
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76===== Classement Final ====="));
            int rank = 1;
            for (TeamData team : sortedTeams) {
                String timeFormatted = PrintFinalGPPositionsProcedure.formatTicksToTime(team.timeTicks);
                MutableComponent prefix = Component.literal((String)("\u00a7e" + rank + ". \u00a7r"));
                MutableComponent stats = Component.literal((String)String.format(" \u00a77 T:%d - CP:%d | Temps: %s", team.laps, team.checkpoints, timeFormatted));
                player.sendSystemMessage((Component)prefix.copy().append(team.displayNameComponent).append((Component)stats));
                ++rank;
            }
        }
    }

    private static String formatTicksToTime(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private static int getPlayerScore(Scoreboard scoreboard, String playerName, Objective objective) {
        ScoreAccess score = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)playerName), objective);
        return score != null ? score.get() : 0;
    }
}

