/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import java.util.List;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class MonsterTickProcedure {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Player player2 = player;
        if (player2.level().isClientSide) {
            return;
        }
        CrazythingsModVariables.PlayerVariables variables = (CrazythingsModVariables.PlayerVariables)player2.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        if (!variables.isMonster) {
            return;
        }
        double dx = player2.getX() - variables.lastMonsterX;
        double dz = player2.getZ() - variables.lastMonsterZ;
        double speedXZ = Math.sqrt(dx * dx + dz * dz);
        variables.lastMonsterX = player2.getX();
        variables.lastMonsterZ = player2.getZ();
        if (speedXZ < 0.4) {
            return;
        }
        AABB collisionBox = player2.getBoundingBox().inflate(0.5);
        List targets = player2.level().getEntitiesOfClass(LivingEntity.class, collisionBox, e -> e != player2);
        for (LivingEntity target : targets) {
            target.hurt(player2.damageSources().mobAttack((LivingEntity)player2), 1.5f);
            target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 0, false, true));
            Vec3 knockback = target.position().subtract(player2.position()).normalize().scale(1.0);
            target.push(knockback.x, 0.3, knockback.z);
            target.hurtMarked = true;
        }
    }
}

