/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Predicate;
import net.mcreator.crazythings.init.CrazythingsModSounds;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LaserGunRightclickedProcedure {
    public static Entity fireLaser(LevelAccessor world, Entity shooter) {
        return LaserGunRightclickedProcedure.fireLaser(world, shooter, e -> true, new Vec3(1.0, 0.0, 0.0), true);
    }

    public static Entity fireLaser(LevelAccessor world, Entity shooter, Predicate<Entity> entityTypeFilter) {
        return LaserGunRightclickedProcedure.fireLaser(world, shooter, entityTypeFilter, new Vec3(1.0, 0.0, 0.0), true);
    }

    public static Entity fireLaser(LevelAccessor world, Entity shooter, Predicate<Entity> entityTypeFilter, Vec3 color, boolean playLaserSound) {
        Vec3 maxEnd;
        Vec3 blockHitPos;
        Vec3 end;
        Vec3 look;
        if (world.isClientSide() || shooter == null) {
            return null;
        }
        Vec3 eyePos = shooter.getEyePosition();
        Vec3 start = LaserGunRightclickedProcedure.calculateMuzzlePosition(eyePos, look = shooter.getLookAngle());
        Pair<Entity, Vec3> entityHit = LaserGunRightclickedProcedure.rayTraceEntity(shooter, start, end = (blockHitPos = LaserGunRightclickedProcedure.rayTraceBlock(shooter, eyePos, maxEnd = eyePos.add(look.scale(30.0)))) != null ? blockHitPos : maxEnd, entityTypeFilter);
        if (entityHit != null) {
            end = (Vec3)entityHit.getSecond();
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            LaserGunRightclickedProcedure.spawnLaserParticles(serverWorld, start, end, color);
            if (playLaserSound) {
                LaserGunRightclickedProcedure.playLaserSound(serverWorld, shooter);
            }
        }
        if (entityHit != null) {
            Entity target = (Entity)entityHit.getFirst();
            return target;
        }
        return null;
    }

    private static Vec3 calculateMuzzlePosition(Vec3 eyePos, Vec3 look) {
        Vec3 rightVec = look.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 downVec = rightVec.cross(look).normalize();
        return eyePos.add(look.scale(0.5)).add(rightVec.scale(0.3)).add(downVec.scale(-0.2));
    }

    static Vec3 rayTraceBlock(Entity shooter, Vec3 start, Vec3 end) {
        BlockHitResult hit = shooter.level().clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter));
        if (hit.getType() != HitResult.Type.MISS) {
            return hit.getLocation();
        }
        return null;
    }

    public static Pair<Entity, Vec3> rayTraceEntity(Entity shooter, Vec3 start, Vec3 end, Predicate<Entity> entityTypeFilter) {
        Level level = shooter.level();
        AABB searchBox = new AABB(start, end).inflate(1.0);
        Entity closestEntity = null;
        Vec3 closestHitPos = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : level.getEntities(shooter, searchBox, e -> e.isPickable() && e != shooter && entityTypeFilter.test((Entity)e))) {
            double dist;
            AABB inflatedBox = entity.getBoundingBox().inflate(0.3);
            Optional optHit = inflatedBox.clip(start, end);
            if (!optHit.isPresent() || !((dist = start.distanceTo((Vec3)optHit.get())) < closestDistance)) continue;
            closestEntity = entity;
            closestHitPos = (Vec3)optHit.get();
            closestDistance = dist;
        }
        if (closestEntity != null && closestHitPos != null) {
            return Pair.of(closestEntity, closestHitPos);
        }
        return null;
    }

    public static void spawnLaserParticles(ServerLevel world, Vec3 start, Vec3 end, Vec3 color) {
        Vec3 direction = end.subtract(start).normalize();
        double distance = start.distanceTo(end);
        for (double i = 0.0; i <= distance; i += 0.1) {
            Vec3 pos = start.add(direction.scale(i));
            world.sendParticles((ParticleOptions)new DustParticleOptions(color.toVector3f(), 0.2f), pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void playLaserSound(ServerLevel world, Entity shooter) {
        world.playSound(null, shooter.blockPosition(), (SoundEvent)CrazythingsModSounds.LASER_GAME_SHOOT.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
    }
}

