/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.mcreator.crazythings.init.CrazythingsModItems;
import net.mcreator.crazythings.procedures.GetClosestBaseProcedure;
import net.mcreator.crazythings.utils.LaserGameDataHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class LaserGameStartProcedure {
    private static final String TEAM_RED = "red";
    private static final String TEAM_CYAN = "cyan";
    private static final String RED_TEAM_NAME = "red_laser_game";
    private static final String CYAN_TEAM_NAME = "cyan_laser_game";

    public static void setupTeams(LevelAccessor world) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        ServerScoreboard scoreboard = serverLevel.getScoreboard();
        LaserGameStartProcedure.createAndModifyTeam(serverLevel, (Scoreboard)scoreboard, RED_TEAM_NAME, "Red Team", TEAM_RED);
        LaserGameStartProcedure.createAndModifyTeam(serverLevel, (Scoreboard)scoreboard, CYAN_TEAM_NAME, "Cyan Team", "aqua");
    }

    private static void clearTeamPlayers(Scoreboard scoreboard, PlayerTeam team) {
        if (team == null) {
            return;
        }
        ArrayList players = new ArrayList(team.getPlayers());
        for (String playerName : players) {
            scoreboard.removePlayerFromTeam(playerName, team);
        }
    }

    private static void createAndModifyTeam(ServerLevel serverLevel, Scoreboard scoreboard, String teamName, String displayName, String colorName) {
        PlayerTeam team = scoreboard.getPlayerTeam(teamName);
        if (team == null) {
            team = scoreboard.addPlayerTeam(teamName);
        }
        String cmdDisplayName = String.format("team modify %s displayName \"%s\"", teamName, displayName);
        String cmdColor = String.format("team modify %s color %s", teamName, colorName);
        CommandSourceStack source = serverLevel.getServer().createCommandSourceStack();
        LaserGameStartProcedure.runCommand(serverLevel, source, cmdDisplayName);
        LaserGameStartProcedure.runCommand(serverLevel, source, cmdColor);
    }

    public static void runCommand(ServerLevel serverLevel, CommandSourceStack source, String command) {
        CommandDispatcher dispatcher = serverLevel.getServer().getCommands().getDispatcher();
        String trimmedCommand = command.startsWith("/") ? command.substring(1) : command;
        ParseResults parseResults = dispatcher.parse(trimmedCommand, (Object)source);
        serverLevel.getServer().getCommands().performCommand(parseResults, trimmedCommand);
    }

    public static void execute(LevelAccessor world, double x, double y, double z) {
        BlockPos origin = new BlockPos((int)x, (int)y, (int)z);
        BlockPos redBase = GetClosestBaseProcedure.getClosestBase(world, origin, TEAM_RED);
        BlockPos cyanBase = GetClosestBaseProcedure.getClosestBase(world, origin, TEAM_CYAN);
        if (redBase == null || cyanBase == null) {
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        ServerScoreboard scoreboard = serverLevel.getScoreboard();
        PlayerTeam redTeam = scoreboard.getPlayerTeam(RED_TEAM_NAME);
        PlayerTeam cyanTeam = scoreboard.getPlayerTeam(CYAN_TEAM_NAME);
        if (redTeam == null || cyanTeam == null) {
            LaserGameStartProcedure.setupTeams(world);
            redTeam = scoreboard.getPlayerTeam(RED_TEAM_NAME);
            cyanTeam = scoreboard.getPlayerTeam(CYAN_TEAM_NAME);
        }
        if (redTeam == null || cyanTeam == null) {
            return;
        }
        LaserGameStartProcedure.clearTeamPlayers((Scoreboard)scoreboard, redTeam);
        LaserGameStartProcedure.clearTeamPlayers((Scoreboard)scoreboard, cyanTeam);
        ArrayList<Entity> playingEntities = new ArrayList<Entity>();
        for (Entity entity : new ArrayList(world.players())) {
            LivingEntity living;
            String color;
            if (!(entity instanceof LivingEntity) || (color = LaserGameStartProcedure.getPlayerColor(living = (LivingEntity)entity)) == null) continue;
            LaserGameDataHelper.resetLaserGamePlayerData(entity);
            LaserGameDataHelper.setLaserGameNbLives(entity, LaserGameDataHelper.getLaserGameNbMaxLives(world));
            BlockPos base = color.equals(TEAM_RED) ? redBase : cyanBase;
            LaserGameDataHelper.setLaserGameBase(entity, base == null ? null : base.getCenter());
            LaserGameDataHelper.setLaserGameIsPlaying(entity, true);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (color.equals(TEAM_RED)) {
                    scoreboard.addPlayerToTeam(serverPlayer.getScoreboardName(), redTeam);
                } else if (color.equals(TEAM_CYAN)) {
                    scoreboard.addPlayerToTeam(serverPlayer.getScoreboardName(), cyanTeam);
                }
            }
            playingEntities.add(entity);
        }
        LaserGameDataHelper.sync(world);
        if (!playingEntities.isEmpty()) {
            String playersList = playingEntities.stream().map(e -> {
                String team = LaserGameStartProcedure.getPlayerColor((LivingEntity)e);
                String name = e.getName().getString();
                ChatFormatting colorFormat = TEAM_RED.equals(team) ? ChatFormatting.RED : ChatFormatting.AQUA;
                return String.valueOf(colorFormat) + name + String.valueOf(ChatFormatting.RESET) + " (" + String.valueOf(colorFormat) + team.toUpperCase() + String.valueOf(ChatFormatting.RESET) + ")";
            }).collect(Collectors.joining(", "));
            MutableComponent message = Component.literal((String)"Le Laser Game \u00e0 commenc\u00e9! Joueurs: ").append((Component)Component.literal((String)playersList));
            for (Entity entity : playingEntities) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.sendSystemMessage((Component)message, false);
            }
        }
    }

    private static String getPlayerColor(LivingEntity entity) {
        ItemStack chest = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (chest.getItem() == CrazythingsModItems.CYAN_LASER_GAME_ARMOR_CHESTPLATE.get()) {
            return TEAM_CYAN;
        }
        if (chest.getItem() == CrazythingsModItems.RED_LASER_GAME_ARMOR_CHESTPLATE.get()) {
            return TEAM_RED;
        }
        return null;
    }
}

