/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.procedures.LaserGunRightclickedProcedure;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class LaserActivatorItemInHandTickProcedure {
    private static int tickCounter = 0;

    public static void execute(Entity entity) {
        if (entity == null || entity.level().isClientSide()) {
            return;
        }
        if (((CrazythingsModVariables.PlayerVariables)entity.getData(CrazythingsModVariables.PLAYER_VARIABLES)).isSuperMan) {
            if (++tickCounter < 3) {
                return;
            }
            tickCounter = 0;
            ServerLevel world = (ServerLevel)entity.level();
            Vec3 eyePos = entity.getEyePosition();
            Vec3 look = entity.getLookAngle();
            Vec3 up = new Vec3(0.0, 1.0, 0.0);
            Vec3 right = look.cross(up).normalize();
            Vec3 baseStart = eyePos.add(up.scale(0.06));
            Vec3 leftStart = baseStart.subtract(right.scale(0.15));
            Vec3 rightStart = baseStart.add(right.scale(0.15));
            Vec3 maxEndLeft = leftStart.add(look.scale(30.0));
            Vec3 maxEndRight = rightStart.add(look.scale(30.0));
            Predicate<Entity> filter = target -> target != entity && target instanceof LivingEntity && target.isAlive();
            LaserActivatorItemInHandTickProcedure.handleLaser(world, entity, leftStart, maxEndLeft, filter);
            LaserActivatorItemInHandTickProcedure.handleLaser(world, entity, rightStart, maxEndRight, filter);
        }
    }

    private static DamageSource getIndirectMagicDamage(ServerLevel world, Entity direct, Entity source) {
        Holder.Reference damageType = world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.INDIRECT_MAGIC);
        return new DamageSource((Holder)damageType, direct, source);
    }

    private static void handleLaser(ServerLevel world, Entity shooter, Vec3 start, Vec3 maxEnd, Predicate<Entity> entityTypeFilter) {
        Entity target;
        Pair<Entity, Vec3> hit;
        Vec3 end = LaserGunRightclickedProcedure.rayTraceBlock(shooter, start, maxEnd);
        if (end == null) {
            end = maxEnd;
        }
        if ((hit = LaserGunRightclickedProcedure.rayTraceEntity(shooter, start, end, entityTypeFilter)) != null) {
            end = (Vec3)hit.getSecond();
        }
        LaserGunRightclickedProcedure.spawnLaserParticles(world, start, end, new Vec3(1.0, 0.0, 0.0));
        if (hit != null && (target = (Entity)hit.getFirst()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.hurt(LaserActivatorItemInHandTickProcedure.getIndirectMagicDamage(world, shooter, shooter), 2.0f);
        }
    }
}

