/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import io.github.foundationgames.automobility.entity.AutomobileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.crazythings.init.CrazythingsModItems;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.procedures.GpInitGameProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class IncreaseCheckpointValueProcedure {
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        IncreaseCheckpointValueProcedure.execute((Event)event);
    }

    public static void execute() {
        IncreaseCheckpointValueProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
        String teamName;
        if (!(event instanceof PlayerTickEvent.Post)) {
            return;
        }
        PlayerTickEvent.Post playerTickEvent = (PlayerTickEvent.Post)event;
        Player player = playerTickEvent.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        Level level = player.level();
        if (!CrazythingsModVariables.MapVariables.get((LevelAccessor)level).increasegptimer) {
            return;
        }
        Scoreboard scoreboard = level.getScoreboard();
        if (player.getTeam() == null) {
            return;
        }
        String fakePlayerName = teamName = player.getTeam().getName();
        Objective checkpointObjective = scoreboard.getObjective("checkpoints");
        Objective lapObjective = scoreboard.getObjective("laps");
        Objective timerObjective = scoreboard.getObjective("race_timer");
        if (checkpointObjective == null || lapObjective == null || timerObjective == null) {
            return;
        }
        int currentTimer = (int)CrazythingsModVariables.MapVariables.get((LevelAccessor)level).gptimer;
        if ((double)currentTimer % CrazythingsModVariables.MapVariables.get((LevelAccessor)level).gpgiveitemsinterval == 0.0) {
            IncreaseCheckpointValueProcedure.giveRandomItemsToSecondPassengers(level, scoreboard);
        }
        ScoreAccess fakePlayerScore = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)fakePlayerName), checkpointObjective);
        int currentCheckpoint = fakePlayerScore.get();
        ScoreAccess lapScore = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)fakePlayerName), lapObjective);
        int currentLaps = lapScore.get();
        double range = 4.0;
        AABB area = new AABB(player.position().subtract(range, range, range), player.position().add(range, range, range));
        List nearbyMarkers = level.getEntities((Entity)player, area, e -> e instanceof Marker && e.getTags().contains("checkpoint"));
        for (Entity entity : nearbyMarkers) {
            Marker checkpointMarker = (Marker)entity;
            int markerCheckpointNumber = 0;
            if (checkpointMarker.getPersistentData().contains("CheckpointNumber")) {
                markerCheckpointNumber = checkpointMarker.getPersistentData().getInt("CheckpointNumber");
            }
            int nbLaps = (int)CrazythingsModVariables.MapVariables.get((LevelAccessor)level).nbLaps;
            if (markerCheckpointNumber != currentCheckpoint + 1 || currentLaps >= nbLaps) continue;
            int totalCheckpoints = markerCheckpointNumber;
            int newLaps = totalCheckpoints / 10;
            int newCheckpointValue = totalCheckpoints % 10;
            int updatedLaps = currentLaps + newLaps;
            ScoreAccess timerScore = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)fakePlayerName), timerObjective);
            timerScore.set(currentTimer);
            lapScore.set(updatedLaps);
            fakePlayerScore.set(newCheckpointValue);
            if (updatedLaps >= nbLaps) {
                level.players().forEach(p -> {
                    if (p.getTeam() != null && p.getTeam().getName().equals(teamName)) {
                        p.sendSystemMessage((Component)Component.literal((String)"L'\u00e9quipe ").append((Component)player.getTeam().getFormattedDisplayName()).append(" a termin\u00e9 la course !"));
                    }
                });
            }
            GpInitGameProcedure.refreshTeamScoreboardDisplay((LevelAccessor)level);
            break;
        }
    }

    private static void giveRandomItemsToSecondPassengers(Level level, Scoreboard scoreboard) {
        List allPlayers = level.players();
        HashMap<Player, Integer> playerPositions = new HashMap<Player, Integer>();
        int lapWeight = 1000;
        ArrayList<Player> eligiblePlayers = new ArrayList<Player>();
        for (Player player : allPlayers) {
            String teamName;
            AutomobileEntity automobile;
            List passengers;
            Entity vehicle = player.getVehicle();
            if (!(vehicle instanceof AutomobileEntity) || ((passengers = (automobile = (AutomobileEntity)vehicle).getPassengers()).size() == 1 ? passengers.get(0) != player : passengers.get(1) != player)) continue;
            eligiblePlayers.add(player);
            if (player.getTeam() == null) continue;
            String fakePlayerName = teamName = player.getTeam().getName();
            Objective checkpointObjective = scoreboard.getObjective("checkpoints");
            Objective lapObjective = scoreboard.getObjective("laps");
            if (checkpointObjective == null || lapObjective == null) continue;
            ScoreAccess checkpointScore = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)fakePlayerName), checkpointObjective);
            ScoreAccess lapScore = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)fakePlayerName), lapObjective);
            int score = lapScore.get() * lapWeight + checkpointScore.get();
            playerPositions.put(player, score);
        }
        if (eligiblePlayers.isEmpty()) {
            return;
        }
        eligiblePlayers.sort((p1, p2) -> {
            int s1 = playerPositions.getOrDefault(p1, 0);
            int s2 = playerPositions.getOrDefault(p2, 0);
            return Integer.compare(s2, s1);
        });
        int totalPlayers = eligiblePlayers.size();
        for (int i = 0; i < totalPlayers; ++i) {
            int q;
            int quantity;
            Player player = (Player)eligiblePlayers.get(i);
            int position = i + 1;
            double posRatio = totalPlayers == 1 ? 0.0 : (double)(position - 1) / (double)(totalPlayers - 1);
            double boosterChance = Math.pow(posRatio, 1.5);
            boolean giveBooster = random.nextDouble() < boosterChance;
            int maxBlocks = 1;
            int maxBoosters = 2;
            if (giveBooster) {
                quantity = (int)Math.min((long)maxBoosters, Math.max(1L, Math.round(posRatio * (double)maxBoosters)));
                for (q = 0; q < quantity; ++q) {
                    ItemStack boosterStack = new ItemStack((ItemLike)CrazythingsModItems.BOOSTER.get());
                    player.getInventory().add(boosterStack);
                }
                continue;
            }
            quantity = (int)Math.min((long)maxBlocks, Math.max(1L, Math.round((1.0 - posRatio) * (double)maxBlocks)));
            for (q = 0; q < quantity; ++q) {
                ItemStack blockStack = new ItemStack((ItemLike)Blocks.RED_WOOL);
                player.getInventory().add(blockStack);
            }
        }
    }
}

