/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import java.util.List;
import net.mcreator.crazythings.init.CrazythingsModSounds;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class HeartbeatSoundProcedure {
    private static int heartbeatTimer = 0;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player == null || level == null) {
            return;
        }
        AABB detectionBox = player.getBoundingBox().inflate(20.0);
        List monsters = level.getEntitiesOfClass(Player.class, detectionBox, p -> {
            if (p == player) {
                return false;
            }
            return ((CrazythingsModVariables.PlayerVariables)p.getData(CrazythingsModVariables.PLAYER_VARIABLES)).isMonster;
        });
        if (monsters.isEmpty()) {
            heartbeatTimer = 0;
            return;
        }
        double minDistance = monsters.stream().mapToDouble(m -> m.distanceTo((Entity)player)).min().orElse(Double.MAX_VALUE);
        int delay = Math.max(8, (int)(minDistance * 3.0));
        if (--heartbeatTimer <= 0) {
            level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), (SoundEvent)CrazythingsModSounds.HEARTBEAT.get(), SoundSource.AMBIENT, 1.0f / (float)(minDistance / 2.0), 1.0f);
            heartbeatTimer = delay;
        }
    }
}

