/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class GpInitGameProcedure {
    private static final List<String> TEAM_NAMES = List.of("white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink");

    public static void execute(LevelAccessor world) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Scoreboard scoreboard = level.getScoreboard();
        GpInitGameProcedure.clearPlayerScoresForObjective(scoreboard, scoreboard.getObjective("laps"));
        GpInitGameProcedure.clearPlayerScoresForObjective(scoreboard, scoreboard.getObjective("checkpoints"));
        GpInitGameProcedure.clearPlayerScoresForObjective(scoreboard, scoreboard.getObjective("positions"));
        GpInitGameProcedure.clearPlayerScoresForObjective(scoreboard, scoreboard.getObjective("race_display"));
        GpInitGameProcedure.clearPlayerScoresForObjective(scoreboard, scoreboard.getObjective("race_timer"));
        GpInitGameProcedure.resetObjectives(scoreboard, "laps", "checkpoints", "positions", "race_display", "race_timer");
        GpInitGameProcedure.getOrCreateObjective(scoreboard, "race_timer", "Race Timer");
        GpInitGameProcedure.getOrCreateObjective(scoreboard, "laps", "Laps");
        GpInitGameProcedure.getOrCreateObjective(scoreboard, "checkpoints", "Checkpoints");
        GpInitGameProcedure.getOrCreateObjective(scoreboard, "positions", "Position");
        Objective displayObjective = GpInitGameProcedure.getOrCreateObjective(scoreboard, "race_display", "Crazy Explorer");
        scoreboard.setDisplayObjective(DisplaySlot.SIDEBAR, displayObjective);
        GpInitGameProcedure.refreshTeamScoreboardDisplay((LevelAccessor)level);
    }

    public static void refreshTeamScoreboardDisplay(LevelAccessor world) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Scoreboard scoreboard = level.getScoreboard();
        Objective lapsObjective = scoreboard.getObjective("laps");
        Objective checkpointsObjective = scoreboard.getObjective("checkpoints");
        Objective displayObjective = scoreboard.getObjective("race_display");
        Objective positionObjective = scoreboard.getObjective("positions");
        if (lapsObjective == null || checkpointsObjective == null || displayObjective == null || positionObjective == null) {
            return;
        }
        class TeamData {
            String name;
            String displayName;
            int lapSum;
            int checkpointSum;
            int score;
            List<String> members;

            TeamData(String name, int lapSum, int checkpointSum, String displayName, List<String> members) {
                this.name = name;
                this.lapSum = lapSum;
                this.checkpointSum = checkpointSum;
                this.members = members;
                this.score = lapSum * 100 + checkpointSum;
                this.displayName = displayName;
            }
        }
        ArrayList<TeamData> validTeams = new ArrayList<TeamData>();
        for (String teamName : TEAM_NAMES) {
            PlayerTeam playerTeam = scoreboard.getPlayerTeam(teamName);
            if (playerTeam == null) continue;
            String displayName = playerTeam.getDisplayName().getString();
            ArrayList<String> members = new ArrayList<String>();
            int totalLaps = 0;
            int totalCheckpoints = 0;
            totalCheckpoints += GpInitGameProcedure.getPlayerScore(scoreboard, teamName, checkpointsObjective);
            totalLaps += GpInitGameProcedure.getPlayerScore(scoreboard, teamName, lapsObjective);
            for (String playerName : playerTeam.getPlayers()) {
                Optional<Player> playerOpt = level.players().stream().filter(p -> p.getScoreboardName().equals(playerName)).findFirst();
                if (!playerOpt.isPresent()) continue;
                members.add(playerName);
                totalLaps += GpInitGameProcedure.getPlayerScore(scoreboard, playerName, lapsObjective);
                totalCheckpoints += GpInitGameProcedure.getPlayerScore(scoreboard, playerName, checkpointsObjective);
            }
            if (members.isEmpty() && totalCheckpoints <= 0 && totalLaps <= 0) continue;
            validTeams.add(new TeamData(teamName, totalLaps, totalCheckpoints, displayName, members));
        }
        validTeams.sort(Comparator.comparingInt(t -> -t.score));
        GpInitGameProcedure.clearSidebarScores(scoreboard, displayObjective);
        int position = 1;
        for (TeamData teamData : validTeams) {
            String displayLine = teamData.displayName + " " + teamData.lapSum + " - " + teamData.checkpointSum;
            int scoreValue = teamData.score;
            ScoreAccess score = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)displayLine), displayObjective);
            score.set(scoreValue);
            ScoreAccess posScore = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)teamData.name), positionObjective);
            posScore.set(position);
            ++position;
        }
    }

    private static void clearPlayerScoresForObjective(Scoreboard scoreboard, Objective objective) {
        for (ScoreHolder holder : new ArrayList(scoreboard.getTrackedPlayers())) {
            if (scoreboard.getPlayerScoreInfo(holder, objective) == null) continue;
            scoreboard.resetSinglePlayerScore(holder, objective);
        }
    }

    private static Objective getOrCreateObjective(Scoreboard scoreboard, String name, String displayName) {
        Objective obj = scoreboard.getObjective(name);
        if (obj == null) {
            obj = scoreboard.addObjective(name, ObjectiveCriteria.DUMMY, (Component)Component.literal((String)displayName), ObjectiveCriteria.RenderType.INTEGER, false, null);
        }
        return obj;
    }

    private static void resetObjectives(Scoreboard scoreboard, String ... objectiveNames) {
        for (String name : objectiveNames) {
            Objective obj = scoreboard.getObjective(name);
            if (obj == null) continue;
            scoreboard.removeObjective(obj);
        }
    }

    private static int getPlayerScore(Scoreboard scoreboard, String playerName, Objective objective) {
        ScoreAccess score = scoreboard.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)playerName), objective);
        return score != null ? score.get() : 0;
    }

    private static void clearSidebarScores(Scoreboard scoreboard, Objective objective) {
        for (ScoreHolder holder : scoreboard.getTrackedPlayers()) {
            ReadOnlyScoreInfo scoreInfo = scoreboard.getPlayerScoreInfo(holder, objective);
            if (scoreInfo == null) continue;
            scoreboard.resetSinglePlayerScore(holder, objective);
        }
    }
}

