/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import net.mcreator.crazythings.init.CrazythingsModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class GetClosestBaseProcedure {
    public static BlockPos getClosestBase(LevelAccessor world, BlockPos origin, String color) {
        Block targetBlock = GetClosestBaseProcedure.getBlockFromColor(color);
        if (targetBlock == null || world == null) {
            return null;
        }
        BlockPos closest = null;
        double closestDistanceSq = Double.MAX_VALUE;
        int radius = 100;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int dx = -100; dx <= 100; ++dx) {
            for (int dy = -100; dy <= 100; ++dy) {
                for (int dz = -100; dz <= 100; ++dz) {
                    double distSq;
                    mutablePos.set(origin.getX() + dx, origin.getY() + dy, origin.getZ() + dz);
                    BlockState state = world.getBlockState((BlockPos)mutablePos);
                    if (state.getBlock() != targetBlock || !((distSq = mutablePos.distSqr((Vec3i)origin)) < closestDistanceSq)) continue;
                    closestDistanceSq = distSq;
                    closest = mutablePos.immutable();
                }
            }
        }
        return closest;
    }

    private static Block getBlockFromColor(String color) {
        return switch (color.toLowerCase()) {
            case "red" -> (Block)CrazythingsModBlocks.RED_LASER_GAME_BASE.get();
            case "cyan" -> (Block)CrazythingsModBlocks.CYAN_LASER_GAME_BASE.get();
            default -> null;
        };
    }
}

