/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.procedures;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;

public class CrazyPhoneListAndPrintPhonesProcedure {
    private static final Map<String, String> uuidToNameCache = new ConcurrentHashMap<String, String>();

    public static void execute(LevelAccessor world, CommandContext<CommandSourceStack> arguments, Entity entity) {
        if (entity == null || !(entity instanceof ServerPlayer)) {
            return;
        }
        String search = "";
        try {
            search = StringArgumentType.getString(arguments, (String)"search");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.sendSystemMessage((Component)Component.literal((String)"--------------------------------------------"));
        for (String phoneKey : CrazythingsModVariables.MapVariables.get((LevelAccessor)world).phones.getAllKeys()) {
            String string;
            String string2;
            String string3;
            CompoundTag compoundTag;
            Tag tag = CrazythingsModVariables.MapVariables.get((LevelAccessor)world).phones.get(phoneKey);
            if (tag instanceof CompoundTag) {
                CompoundTag _compoundTag = (CompoundTag)tag;
                compoundTag = _compoundTag.copy();
            } else {
                compoundTag = new CompoundTag();
            }
            CompoundTag phone = compoundTag;
            Tag tag2 = phone.get("uuid");
            if (tag2 instanceof StringTag) {
                StringTag s2 = (StringTag)tag2;
                string3 = s2.getAsString();
            } else {
                string3 = "";
            }
            String uuid = string3;
            Tag tag3 = phone.get("name");
            if (tag3 instanceof StringTag) {
                StringTag s3 = (StringTag)tag3;
                string2 = s3.getAsString();
            } else {
                string2 = "";
            }
            String name = string2;
            Tag tag4 = phone.get("skin");
            if (tag4 instanceof StringTag) {
                StringTag s4 = (StringTag)tag4;
                string = s4.getAsString();
            } else {
                string = "";
            }
            String skin = string;
            String lowerSearch = search.toLowerCase();
            String playerName = uuidToNameCache.get(uuid);
            if (playerName != null) {
                if (!phoneKey.toLowerCase().contains(lowerSearch) && !name.toLowerCase().contains(lowerSearch) && !playerName.toLowerCase().contains(lowerSearch)) continue;
                MutableComponent message = CrazyPhoneListAndPrintPhonesProcedure.buildPhoneChatMessage(name, skin, uuid, phoneKey, playerName);
                player.sendSystemMessage((Component)message);
                continue;
            }
            CrazyPhoneListAndPrintPhonesProcedure.fetchPlayerNameFromUUIDAsync(uuid).thenAccept(fetchedName -> {
                String finalName = fetchedName != null && !fetchedName.isEmpty() ? fetchedName : "Inconnu";
                uuidToNameCache.put(uuid, finalName);
                if (phoneKey.toLowerCase().contains(lowerSearch) || name.toLowerCase().contains(lowerSearch) || finalName.toLowerCase().contains(lowerSearch)) {
                    MutableComponent message = CrazyPhoneListAndPrintPhonesProcedure.buildPhoneChatMessage(name, skin, uuid, phoneKey, finalName);
                    player.getServer().execute(() -> player.sendSystemMessage((Component)message));
                }
            });
        }
    }

    public static CompletableFuture<String> fetchPlayerNameFromUUIDAsync(String uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String line;
                String cleanUUID = uuid.replace("-", "");
                URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + cleanUUID);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    return null;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                return json.get("name").getAsString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    private static MutableComponent buildPhoneChatMessage(String name, String skin, String uuid, String number, String pseudo) {
        MutableComponent msg = Component.literal((String)"");
        msg.append((Component)Component.literal((String)number).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC}));
        msg.append((Component)Component.literal((String)" : ").withStyle(ChatFormatting.GRAY));
        msg.append((Component)Component.literal((String)name).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.BOLD}));
        msg.append((Component)Component.literal((String)" \u2022 ").withStyle(ChatFormatting.GRAY));
        msg.append((Component)Component.literal((String)"[Skin]").withStyle(style -> style.withColor(ChatFormatting.GRAY).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Cliquez pour copier l\u2019apparence"))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, skin))));
        msg.append((Component)Component.literal((String)" \u2022 ").withStyle(ChatFormatting.GRAY));
        msg.append((Component)Component.literal((String)("[" + pseudo + "]")).withStyle(style -> style.withColor(ChatFormatting.GRAY).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Cliquez pour copier l\u2019UUID"))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid))));
        msg.append((Component)Component.literal((String)" | ").withStyle(ChatFormatting.GRAY));
        msg.append((Component)Component.literal((String)"[GIVE]").withStyle(style -> style.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Cliquez pour prendre ce t\u00e9l\u00e9phone"))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/phoneGive " + number))));
        msg.append((Component)Component.literal((String)" ").withStyle(ChatFormatting.GRAY));
        msg.append((Component)Component.literal((String)"[X]").withStyle(style -> style.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Cliquez pour supprimer ce t\u00e9l\u00e9phone"))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/phoneDelete " + number))));
        return msg;
    }
}

