/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.client.gui.CrazyPhoneContactInfoScreenScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record UpdateContactInfoMessage(String name, String uuid, String number) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateContactInfoMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"update_contact_info"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateContactInfoMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        UpdateContactInfoMessage.writeComponent(buffer, (Component)Component.literal((String)message.name));
        UpdateContactInfoMessage.writeComponent(buffer, (Component)Component.literal((String)message.uuid));
        UpdateContactInfoMessage.writeComponent(buffer, (Component)Component.literal((String)message.number));
    }, buffer -> new UpdateContactInfoMessage(UpdateContactInfoMessage.readComponent(buffer).getString(), UpdateContactInfoMessage.readComponent(buffer).getString(), UpdateContactInfoMessage.readComponent(buffer).getString()));

    public CustomPacketPayload.Type<UpdateContactInfoMessage> type() {
        return TYPE;
    }

    public static void handleData(UpdateContactInfoMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                Screen patt0$temp = mc.screen;
                if (patt0$temp instanceof CrazyPhoneContactInfoScreenScreen) {
                    CrazyPhoneContactInfoScreenScreen screen = (CrazyPhoneContactInfoScreenScreen)patt0$temp;
                    screen.updateContactInfo(message.name, message.uuid, message.number);
                }
            });
        }
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, UpdateContactInfoMessage::handleData);
    }
}

