/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.client.gui.ScratchTicket2InterfaceScreen;
import net.mcreator.crazythings.client.gui.ScratchTicketInterfaceScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ScratchTicketUpdatePacket(int isWinning, boolean scratched) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ScratchTicketUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"scratch_ticket_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScratchTicketUpdatePacket> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeVarInt(message.isWinning);
        buffer.writeBoolean(message.scratched);
    }, buffer -> new ScratchTicketUpdatePacket(buffer.readVarInt(), buffer.readBoolean()));

    public CustomPacketPayload.Type<ScratchTicketUpdatePacket> type() {
        return TYPE;
    }

    public static void handleData(ScratchTicketUpdatePacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            Screen currentScreen = mc.screen;
            if (currentScreen instanceof ScratchTicketInterfaceScreen) {
                ScratchTicketInterfaceScreen screen = (ScratchTicketInterfaceScreen)currentScreen;
                screen.setScratched(message.scratched);
                screen.setWinning(message.isWinning);
            } else if (currentScreen instanceof ScratchTicket2InterfaceScreen) {
                ScratchTicket2InterfaceScreen screen = (ScratchTicket2InterfaceScreen)currentScreen;
                screen.setScratched(message.scratched);
                screen.setWinning(message.isWinning);
            }
        });
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, ScratchTicketUpdatePacket::handleData);
    }
}

