/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.world.inventory.CrazyPhonePictureFoldersScreenMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record PictureFoldersSlotClickMessage(int slotIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PictureFoldersSlotClickMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"picture_folders_slot_click"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PictureFoldersSlotClickMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeInt(message.slotIndex), buffer -> new PictureFoldersSlotClickMessage(buffer.readInt()));

    public CustomPacketPayload.Type<PictureFoldersSlotClickMessage> type() {
        return TYPE;
    }

    public static void handleData(PictureFoldersSlotClickMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                AbstractContainerMenu patt0$temp = entity.containerMenu;
                if (patt0$temp instanceof CrazyPhonePictureFoldersScreenMenu) {
                    CrazyPhonePictureFoldersScreenMenu menu = (CrazyPhonePictureFoldersScreenMenu)patt0$temp;
                    menu.handleSlotClick(message.slotIndex());
                }
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)("Error: " + e.getMessage())));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, PictureFoldersSlotClickMessage::handleData);
    }
}

