/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.network.OuijaAnimationPacketClientHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record OuijaAnimationPacket(BlockPos pos, String fullSequence, long waitTime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OuijaAnimationPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"ouija_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OuijaAnimationPacket> STREAM_CODEC = StreamCodec.of((buffer, msg) -> {
        buffer.writeBlockPos(msg.pos);
        buffer.writeUtf(msg.fullSequence);
        buffer.writeLong(msg.waitTime);
    }, buffer -> new OuijaAnimationPacket(buffer.readBlockPos(), buffer.readUtf(Short.MAX_VALUE), buffer.readLong()));

    public CustomPacketPayload.Type<OuijaAnimationPacket> type() {
        return TYPE;
    }

    public static void handleData(OuijaAnimationPacket msg, IPayloadContext context) {
        if (Dist.CLIENT.isClient()) {
            OuijaAnimationPacketClientHandler.handle(msg, context);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, OuijaAnimationPacket::handleData);
    }
}

