/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import java.util.function.Supplier;
import net.mcreator.crazythings.CrazythingsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CrazythingsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"crazythings");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());
    public static double iWorld = 0.0;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        CrazythingsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean canClimbWall = false;
        public CompoundTag changedEffects = new CompoundTag();
        public String crazyPhoneScreenHistory = "\"\"";
        public String currentCrazyPhoneScreenOpened = "\"\"";
        public double hairDryerUseTicks = 0.0;
        public boolean heartbeats = true;
        public double iPlayer = 0.0;
        public boolean isClimbing = false;
        public boolean isMedium = false;
        public boolean isMonster = false;
        public boolean isZombie = false;
        public boolean isZooking = false;
        public Vec3 laserGameBase = Vec3.ZERO;
        public boolean laserGameIsPlaying = false;
        public double laserGameNbLives = 0.0;
        public double laserGameNbShoots = 0.0;
        public ListTag laserGameShoots = new ListTag();
        public double lastMonsterX = 0.0;
        public double lastMonsterZ = 0.0;
        public CompoundTag plantsAroundZombiePlayer = new CompoundTag();
        public double poopFullness = 0.0;
        public Vec3 zookPosition = Vec3.ZERO;
        public boolean isSuperMan = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("canClimbWall", this.canClimbWall);
            nbt.put("changedEffects", (Tag)this.changedEffects);
            nbt.putString("crazyPhoneScreenHistory", this.crazyPhoneScreenHistory);
            nbt.putString("currentCrazyPhoneScreenOpened", this.currentCrazyPhoneScreenOpened);
            nbt.putDouble("hairDryerUseTicks", this.hairDryerUseTicks);
            nbt.putBoolean("heartbeats", this.heartbeats);
            nbt.putDouble("iPlayer", this.iPlayer);
            nbt.putBoolean("isClimbing", this.isClimbing);
            nbt.putBoolean("isMedium", this.isMedium);
            nbt.putBoolean("isMonster", this.isMonster);
            nbt.putBoolean("isZombie", this.isZombie);
            nbt.putBoolean("isZooking", this.isZooking);
            this.laserGameBase = this.laserGameBase == null ? Vec3.ZERO : this.laserGameBase;
            ListTag listTag = new ListTag();
            listTag.addTag(0, (Tag)DoubleTag.valueOf((double)this.laserGameBase.x()));
            listTag.addTag(1, (Tag)DoubleTag.valueOf((double)this.laserGameBase.y()));
            listTag.addTag(2, (Tag)DoubleTag.valueOf((double)this.laserGameBase.z()));
            nbt.put("laserGameBase", (Tag)listTag);
            nbt.putBoolean("laserGameIsPlaying", this.laserGameIsPlaying);
            nbt.putDouble("laserGameNbLives", this.laserGameNbLives);
            nbt.putDouble("laserGameNbShoots", this.laserGameNbShoots);
            nbt.put("laserGameShoots", (Tag)this.laserGameShoots);
            nbt.putDouble("lastMonsterX", this.lastMonsterX);
            nbt.putDouble("lastMonsterZ", this.lastMonsterZ);
            nbt.put("plantsAroundZombiePlayer", (Tag)this.plantsAroundZombiePlayer);
            nbt.putDouble("poopFullness", this.poopFullness);
            this.zookPosition = this.zookPosition == null ? Vec3.ZERO : this.zookPosition;
            listTag = new ListTag();
            listTag.addTag(0, (Tag)DoubleTag.valueOf((double)this.zookPosition.x()));
            listTag.addTag(1, (Tag)DoubleTag.valueOf((double)this.zookPosition.y()));
            listTag.addTag(2, (Tag)DoubleTag.valueOf((double)this.zookPosition.z()));
            nbt.put("zookPosition", (Tag)listTag);
            nbt.putBoolean("isSuperMan", this.isSuperMan);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            CompoundTag plantsAroundZombiePlayer;
            ListTag laserGameShoots;
            CompoundTag changedEffects;
            this.canClimbWall = nbt.getBoolean("canClimbWall");
            Tag tag = nbt.get("changedEffects");
            this.changedEffects = tag instanceof CompoundTag ? (changedEffects = (CompoundTag)tag) : new CompoundTag();
            this.crazyPhoneScreenHistory = nbt.getString("crazyPhoneScreenHistory");
            this.currentCrazyPhoneScreenOpened = nbt.getString("currentCrazyPhoneScreenOpened");
            this.hairDryerUseTicks = nbt.getDouble("hairDryerUseTicks");
            this.heartbeats = nbt.getBoolean("heartbeats");
            this.iPlayer = nbt.getDouble("iPlayer");
            this.isClimbing = nbt.getBoolean("isClimbing");
            this.isMedium = nbt.getBoolean("isMedium");
            this.isMonster = nbt.getBoolean("isMonster");
            this.isZombie = nbt.getBoolean("isZombie");
            this.isZooking = nbt.getBoolean("isZooking");
            ListTag listTag = nbt.getList("laserGameBase", 6);
            this.laserGameBase = new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
            this.laserGameIsPlaying = nbt.getBoolean("laserGameIsPlaying");
            this.laserGameNbLives = nbt.getDouble("laserGameNbLives");
            this.laserGameNbShoots = nbt.getDouble("laserGameNbShoots");
            tag = nbt.get("laserGameShoots");
            this.laserGameShoots = tag instanceof ListTag ? (laserGameShoots = (ListTag)tag) : new ListTag();
            this.lastMonsterX = nbt.getDouble("lastMonsterX");
            this.lastMonsterZ = nbt.getDouble("lastMonsterZ");
            tag = nbt.get("plantsAroundZombiePlayer");
            this.plantsAroundZombiePlayer = tag instanceof CompoundTag ? (plantsAroundZombiePlayer = (CompoundTag)tag) : new CompoundTag();
            this.poopFullness = nbt.getDouble("poopFullness");
            listTag = nbt.getList("zookPosition", 6);
            this.zookPosition = new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
            this.isSuperMan = nbt.getBoolean("isSuperMan");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "crazythings_mapvars";
        public double chichatafcount = 0.0;
        public CompoundTag contacts = new CompoundTag();
        public CompoundTag crazyPhoneMessages = new CompoundTag();
        public double gpgiveitemsinterval = 400.0;
        public double gptimer = 0.0;
        public boolean increasegptimer = false;
        public boolean isMayorElectionOn = false;
        public boolean isMayorVotingOn = false;
        public double laserGameNbMaxLives = 0.0;
        public CompoundTag lastMayorVoteTimestamps = new CompoundTag();
        public CompoundTag mayorsCandidates = new CompoundTag();
        public CompoundTag mayorVotes = new CompoundTag();
        public Vec3 mediumTarotCardsPosition = Vec3.ZERO;
        public double nbLaps = 5.0;
        public ListTag phoneNames = new ListTag();
        public CompoundTag phones = new CompoundTag();
        public Vec3 zookDestination = Vec3.ZERO;
        public Vec3 zookExit = Vec3.ZERO;
        public double scratchTicketWinningPercentage = 5.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            CompoundTag phones;
            ListTag phoneNames;
            CompoundTag mayorVotes;
            CompoundTag mayorsCandidates;
            CompoundTag lastMayorVoteTimestamps;
            CompoundTag crazyPhoneMessages;
            CompoundTag contacts;
            this.chichatafcount = nbt.getDouble("chichatafcount");
            Tag tag = nbt.get("contacts");
            this.contacts = tag instanceof CompoundTag ? (contacts = (CompoundTag)tag) : new CompoundTag();
            tag = nbt.get("crazyPhoneMessages");
            this.crazyPhoneMessages = tag instanceof CompoundTag ? (crazyPhoneMessages = (CompoundTag)tag) : new CompoundTag();
            this.gpgiveitemsinterval = nbt.getDouble("gpgiveitemsinterval");
            this.gptimer = nbt.getDouble("gptimer");
            this.increasegptimer = nbt.getBoolean("increasegptimer");
            this.isMayorElectionOn = nbt.getBoolean("isMayorElectionOn");
            this.isMayorVotingOn = nbt.getBoolean("isMayorVotingOn");
            this.laserGameNbMaxLives = nbt.getDouble("laserGameNbMaxLives");
            tag = nbt.get("lastMayorVoteTimestamps");
            this.lastMayorVoteTimestamps = tag instanceof CompoundTag ? (lastMayorVoteTimestamps = (CompoundTag)tag) : new CompoundTag();
            tag = nbt.get("mayorsCandidates");
            this.mayorsCandidates = tag instanceof CompoundTag ? (mayorsCandidates = (CompoundTag)tag) : new CompoundTag();
            tag = nbt.get("mayorVotes");
            this.mayorVotes = tag instanceof CompoundTag ? (mayorVotes = (CompoundTag)tag) : new CompoundTag();
            ListTag listTag = nbt.getList("mediumTarotCardsPosition", 6);
            this.mediumTarotCardsPosition = new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
            this.nbLaps = nbt.getDouble("nbLaps");
            tag = nbt.get("phoneNames");
            this.phoneNames = tag instanceof ListTag ? (phoneNames = (ListTag)tag) : new ListTag();
            tag = nbt.get("phones");
            this.phones = tag instanceof CompoundTag ? (phones = (CompoundTag)tag) : new CompoundTag();
            listTag = nbt.getList("zookDestination", 6);
            this.zookDestination = new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
            listTag = nbt.getList("zookExit", 6);
            this.zookExit = new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
            this.scratchTicketWinningPercentage = nbt.getDouble("scratchTicketWinningPercentage");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("chichatafcount", this.chichatafcount);
            nbt.put("contacts", (Tag)this.contacts);
            nbt.put("crazyPhoneMessages", (Tag)this.crazyPhoneMessages);
            nbt.putDouble("gpgiveitemsinterval", this.gpgiveitemsinterval);
            nbt.putDouble("gptimer", this.gptimer);
            nbt.putBoolean("increasegptimer", this.increasegptimer);
            nbt.putBoolean("isMayorElectionOn", this.isMayorElectionOn);
            nbt.putBoolean("isMayorVotingOn", this.isMayorVotingOn);
            nbt.putDouble("laserGameNbMaxLives", this.laserGameNbMaxLives);
            nbt.put("lastMayorVoteTimestamps", (Tag)this.lastMayorVoteTimestamps);
            nbt.put("mayorsCandidates", (Tag)this.mayorsCandidates);
            nbt.put("mayorVotes", (Tag)this.mayorVotes);
            this.mediumTarotCardsPosition = this.mediumTarotCardsPosition == null ? Vec3.ZERO : this.mediumTarotCardsPosition;
            ListTag listTag = new ListTag();
            listTag.addTag(0, (Tag)DoubleTag.valueOf((double)this.mediumTarotCardsPosition.x()));
            listTag.addTag(1, (Tag)DoubleTag.valueOf((double)this.mediumTarotCardsPosition.y()));
            listTag.addTag(2, (Tag)DoubleTag.valueOf((double)this.mediumTarotCardsPosition.z()));
            nbt.put("mediumTarotCardsPosition", (Tag)listTag);
            nbt.putDouble("nbLaps", this.nbLaps);
            nbt.put("phoneNames", (Tag)this.phoneNames);
            nbt.put("phones", (Tag)this.phones);
            this.zookDestination = this.zookDestination == null ? Vec3.ZERO : this.zookDestination;
            listTag = new ListTag();
            listTag.addTag(0, (Tag)DoubleTag.valueOf((double)this.zookDestination.x()));
            listTag.addTag(1, (Tag)DoubleTag.valueOf((double)this.zookDestination.y()));
            listTag.addTag(2, (Tag)DoubleTag.valueOf((double)this.zookDestination.z()));
            nbt.put("zookDestination", (Tag)listTag);
            this.zookExit = this.zookExit == null ? Vec3.ZERO : this.zookExit;
            listTag = new ListTag();
            listTag.addTag(0, (Tag)DoubleTag.valueOf((double)this.zookExit.x()));
            listTag.addTag(1, (Tag)DoubleTag.valueOf((double)this.zookExit.y()));
            listTag.addTag(2, (Tag)DoubleTag.valueOf((double)this.zookExit.z()));
            nbt.put("zookExit", (Tag)listTag);
            nbt.putDouble("scratchTicketWinningPercentage", this.scratchTicketWinningPercentage);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "crazythings_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.canClimbWall = original.canClimbWall;
            clone.changedEffects = original.changedEffects;
            clone.heartbeats = original.heartbeats;
            clone.isMedium = original.isMedium;
            clone.isMonster = original.isMonster;
            clone.isZombie = original.isZombie;
            clone.laserGameBase = original.laserGameBase;
            clone.laserGameIsPlaying = original.laserGameIsPlaying;
            clone.laserGameNbLives = original.laserGameNbLives;
            clone.laserGameNbShoots = original.laserGameNbShoots;
            clone.laserGameShoots = original.laserGameShoots;
            clone.plantsAroundZombiePlayer = original.plantsAroundZombiePlayer;
            clone.poopFullness = original.poopFullness;
            clone.zookPosition = original.zookPosition;
            clone.isSuperMan = original.isSuperMan;
            if (!event.isWasDeath()) {
                clone.crazyPhoneScreenHistory = original.crazyPhoneScreenHistory;
                clone.currentCrazyPhoneScreenOpened = original.currentCrazyPhoneScreenOpened;
                clone.hairDryerUseTicks = original.hairDryerUseTicks;
                clone.iPlayer = original.iPlayer;
                clone.isClimbing = original.isClimbing;
                clone.isZooking = original.isZooking;
                clone.lastMonsterX = original.lastMonsterX;
                clone.lastMonsterZ = original.lastMonsterZ;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

