/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.procedures.CrayPhoneTakePhotoProcedure;
import net.mcreator.crazythings.procedures.CrazyPhoneOnpenPictureFoldersScreenProcedure;
import net.mcreator.crazythings.utils.ScreenMenuUtils;
import net.mcreator.crazythings.world.inventory.CrazyPhoneMayorsCandidatesListMenu;
import net.mcreator.crazythings.world.inventory.CrazyphoneHomeScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyphoneHomeScreenButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyphoneHomeScreenButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"crazyphone_home_screen_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyphoneHomeScreenButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        CrazyphoneHomeScreenButtonMessage.writeTextState(message.textstate, buffer);
    }, buffer -> new CrazyphoneHomeScreenButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), CrazyphoneHomeScreenButtonMessage.readTextState(buffer)));

    public CustomPacketPayload.Type<CrazyphoneHomeScreenButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CrazyphoneHomeScreenButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                HashMap<String, String> textstate = message.textstate;
                CrazyphoneHomeScreenButtonMessage.handleButtonAction(entity, buttonID, x, y, z, textstate);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.level();
        HashMap guistate = CrazyphoneHomeScreenMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CrayPhoneTakePhotoProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            CrazyPhoneOnpenPictureFoldersScreenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ScreenMenuUtils.openPhoneContactsMenu(entity, InteractionHand.MAIN_HAND);
        }
        if (buttonID == 3) {
            ScreenMenuUtils.openPhoneCustomMenu(entity, InteractionHand.MAIN_HAND, CrazyPhoneMayorsCandidatesListMenu.class);
        }
    }

    private static void writeTextState(HashMap<String, String> map, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CrazyphoneHomeScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getKey()));
            CrazyphoneHomeScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getValue()));
        }
    }

    private static HashMap<String, String> readTextState(RegistryFriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = CrazyphoneHomeScreenButtonMessage.readComponent(buffer).getString();
            String value = CrazyphoneHomeScreenButtonMessage.readComponent(buffer).getString();
            map.put(key, value);
        }
        return map;
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyphoneHomeScreenButtonMessage::handleData);
    }
}

