/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.procedures.CrazyPhoneTrySignInProcedure;
import net.mcreator.crazythings.world.inventory.CrazyPhoneSignInScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyPhoneSignInScreenButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyPhoneSignInScreenButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"crazy_phone_sign_in_screen_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyPhoneSignInScreenButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        CrazyPhoneSignInScreenButtonMessage.writeTextState(message.textstate, buffer);
    }, buffer -> new CrazyPhoneSignInScreenButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), CrazyPhoneSignInScreenButtonMessage.readTextState(buffer)));

    public CustomPacketPayload.Type<CrazyPhoneSignInScreenButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CrazyPhoneSignInScreenButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                HashMap<String, String> textstate = message.textstate;
                CrazyPhoneSignInScreenButtonMessage.handleButtonAction(entity, buttonID, x, y, z, textstate);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.level();
        HashMap<String, Object> guistate = CrazyPhoneSignInScreenMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CrazyPhoneTrySignInProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
    }

    private static void writeTextState(HashMap<String, String> map, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CrazyPhoneSignInScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getKey()));
            CrazyPhoneSignInScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getValue()));
        }
    }

    private static HashMap<String, String> readTextState(RegistryFriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = CrazyPhoneSignInScreenButtonMessage.readComponent(buffer).getString();
            String value = CrazyPhoneSignInScreenButtonMessage.readComponent(buffer).getString();
            map.put(key, value);
        }
        return map;
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyPhoneSignInScreenButtonMessage::handleData);
    }
}

