/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.utils.ScreenMenuUtils;
import net.mcreator.crazythings.world.inventory.CrazyPhonePicturesScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyPhonePicturesScreenButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyPhonePicturesScreenButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"crazy_phone_pictures_screen_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyPhonePicturesScreenButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        CrazyPhonePicturesScreenButtonMessage.writeTextState(message.textstate, buffer);
    }, buffer -> new CrazyPhonePicturesScreenButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), CrazyPhonePicturesScreenButtonMessage.readTextState(buffer)));

    public CustomPacketPayload.Type<CrazyPhonePicturesScreenButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CrazyPhonePicturesScreenButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                HashMap<String, String> textstate = message.textstate;
                CrazyPhonePicturesScreenButtonMessage.handleButtonAction(entity, buttonID, x, y, z, textstate);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.level();
        HashMap<String, Object> guistate = CrazyPhonePicturesScreenMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        String albumIdStr = textstate.get("albumIndex");
        String selected = textstate.get("selectedSlots");
        int albumId = Integer.parseInt(albumIdStr);
        Set<Integer> selectedSlots = CrazyPhonePicturesScreenButtonMessage.parseSlotList(selected);
        if (buttonID == 0) {
            CrazyPhoneHelper.deleteSelectedAlbumSlotsFromHeldPhone(entity, world, selectedSlots, albumId);
        } else if (buttonID == 1) {
            CrazyPhoneHelper.takeSelectedAlbumSlotsFromHeldPhone(entity, world, selectedSlots, albumId);
        } else if (buttonID == 2) {
            String potentialConversationPage;
            CrazythingsModVariables.PlayerVariables playerData = (CrazythingsModVariables.PlayerVariables)entity.getData(CrazythingsModVariables.PLAYER_VARIABLES);
            List<String> screenHistory = ScreenMenuUtils.getScreenHistory(playerData.crazyPhoneScreenHistory);
            if (screenHistory.size() >= 3 && (potentialConversationPage = screenHistory.get(screenHistory.size() - 3)).contains("crazy_phone_conversation")) {
                String conversationId = ScreenMenuUtils.parseScreenDataFromTag(potentialConversationPage);
                CrazyPhoneHelper.sendSelectedAlbumSlotsFromHeldPhone(entity, world, selectedSlots, albumId, conversationId);
                ScreenMenuUtils.openPhoneConversationMenu(entity, InteractionHand.MAIN_HAND, conversationId);
            }
        }
    }

    private static Set<Integer> parseSlotList(String csv) {
        String[] parts;
        HashSet<Integer> slots = new HashSet<Integer>();
        if (csv == null || csv.isEmpty()) {
            return slots;
        }
        for (String part : parts = csv.split(",")) {
            try {
                slots.add(Integer.parseInt(part.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    private static void writeTextState(HashMap<String, String> map, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CrazyPhonePicturesScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getKey()));
            CrazyPhonePicturesScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getValue()));
        }
    }

    private static HashMap<String, String> readTextState(RegistryFriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = CrazyPhonePicturesScreenButtonMessage.readComponent(buffer).getString();
            String value = CrazyPhonePicturesScreenButtonMessage.readComponent(buffer).getString();
            map.put(key, value);
        }
        return map;
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyPhonePicturesScreenButtonMessage::handleData);
    }
}

