/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.client.gui.CrazyPhoneConversationScreen;
import net.mcreator.crazythings.client.gui.components.MessageData;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyPhoneNewMessageNotificationPacket(CompoundTag messageTag, String senderName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyPhoneNewMessageNotificationPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"new_message_notification"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyPhoneNewMessageNotificationPacket> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeNbt((Tag)(message.messageTag != null ? message.messageTag : new CompoundTag()));
        buffer.writeUtf(message.senderName);
    }, buffer -> new CrazyPhoneNewMessageNotificationPacket(buffer.readNbt(), buffer.readUtf()));

    public CustomPacketPayload.Type<CrazyPhoneNewMessageNotificationPacket> type() {
        return TYPE;
    }

    public static void handleData(CrazyPhoneNewMessageNotificationPacket messagePacket, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                Screen patt0$temp;
                Minecraft mc = Minecraft.getInstance();
                if (mc.player == null) {
                    return;
                }
                MessageData message = CrazyPhoneHelper.getMessageFromTag(messagePacket.messageTag);
                mc.player.sendSystemMessage((Component)Component.literal((String)"\ud83d\udce8 Nouveau message re\u00e7u de ").withStyle(style -> style.withColor(0x55FFFF).withItalic(Boolean.valueOf(true))).append((Component)Component.literal((String)messagePacket.senderName).withStyle(style -> style.withBold(Boolean.valueOf(true)).withColor(65365))));
                SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.note_block.pling"));
                if (sound != null) {
                    mc.player.playNotifySound(sound, SoundSource.PLAYERS, 0.6f, 1.0f);
                }
                if ((patt0$temp = mc.screen) instanceof CrazyPhoneConversationScreen) {
                    CrazyPhoneConversationScreen screen = (CrazyPhoneConversationScreen)patt0$temp;
                    screen.addMessage(messagePacket.senderName, message);
                }
            });
        }
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyPhoneNewMessageNotificationPacket::handleData);
    }
}

