/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import com.mojang.serialization.DynamicOps;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.utils.CameraModHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyPhoneImageActionMessage(ItemStack stack, ImageActionType actionType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyPhoneImageActionMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"crazyphone_image_action"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyPhoneImageActionMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        try {
            buf.writeVarInt(msg.actionType.ordinal());
            Tag tag = (Tag)ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)msg.stack).getOrThrow();
            buf.writeNbt(tag);
        }
        catch (Exception error) {
            CrazythingsMod.LOGGER.warn("Failed to encode ItemStack: {}", (Throwable)error);
        }
    }, buf -> {
        try {
            int actionId = buf.readVarInt();
            ImageActionType actionType = ImageActionType.values()[actionId];
            CompoundTag tag = buf.readNbt();
            ItemStack stack = (ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
            return new CrazyPhoneImageActionMessage(stack, actionType);
        }
        catch (Exception error) {
            CrazythingsMod.LOGGER.warn("Failed to decode ItemStack: {}", (Throwable)error);
            return null;
        }
    });

    public CustomPacketPayload.Type<CrazyPhoneImageActionMessage> type() {
        return TYPE;
    }

    public static void handleData(CrazyPhoneImageActionMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                ServerPlayer player = (ServerPlayer)context.player();
                ItemStack stack = message.stack().copy();
                switch (message.actionType().ordinal()) {
                    case 0: {
                        if (player.getInventory().add(stack)) break;
                        player.drop(stack, false);
                        break;
                    }
                    case 1: {
                        CameraModHelper.tryInsertImageIntoCrazyPhone(player, stack);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyPhoneImageActionMessage::handleData);
    }

    public static enum ImageActionType {
        GIVE_PLAYER,
        GIVE_ALBUM;

    }
}

