/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.procedures.GetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.utils.ScreenMenuUtils;
import net.mcreator.crazythings.world.inventory.CrazyPhonePictureFoldersScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyPhoneConversationButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyPhoneConversationButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"crazy_phone_conversation_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyPhoneConversationButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        CrazyPhoneConversationButtonMessage.writeTextState(message.textstate, buffer);
    }, buffer -> new CrazyPhoneConversationButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), CrazyPhoneConversationButtonMessage.readTextState(buffer)));

    public CustomPacketPayload.Type<CrazyPhoneConversationButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CrazyPhoneConversationButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                HashMap<String, String> textstate = message.textstate;
                CrazyPhoneConversationButtonMessage.handleButtonAction(entity, buttonID, x, y, z, textstate);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            String message;
            String string = message = textstate.containsKey("textin:message") ? textstate.get("textin:message") : "";
            if (message.isEmpty()) {
                return;
            }
            int timestampInMinutes = (int)(Instant.now().getEpochSecond() / 60L);
            String conversationId = textstate.containsKey("conversationId") ? textstate.get("conversationId") : "";
            String senderNumber = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)entity, null);
            CrazyPhoneHelper.addMessage(world, conversationId, senderNumber, message, timestampInMinutes, null);
            CrazythingsModVariables.MapVariables.get((LevelAccessor)world).syncData((LevelAccessor)world);
            if (world.isClientSide()) {
                entity.playNotifySound(SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            ScreenMenuUtils.openPhoneConversationMenu(entity, InteractionHand.MAIN_HAND, conversationId);
        } else if (buttonID == 1) {
            ScreenMenuUtils.openPhoneCustomMenu(entity, InteractionHand.MAIN_HAND, CrazyPhonePictureFoldersScreenMenu.class);
        }
    }

    private static void writeTextState(HashMap<String, String> map, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CrazyPhoneConversationButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getKey()));
            CrazyPhoneConversationButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getValue()));
        }
    }

    private static HashMap<String, String> readTextState(RegistryFriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = CrazyPhoneConversationButtonMessage.readComponent(buffer).getString();
            String value = CrazyPhoneConversationButtonMessage.readComponent(buffer).getString();
            map.put(key, value);
        }
        return map;
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyPhoneConversationButtonMessage::handleData);
    }
}

