/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.network.UpdateContactInfoMessage;
import net.mcreator.crazythings.procedures.CrazyPhoneAddContactToPhoneProcedure;
import net.mcreator.crazythings.procedures.GetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.utils.ScreenMenuUtils;
import net.mcreator.crazythings.world.inventory.CrazyPhoneContactInfoScreenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyPhoneContactInfoScreenButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyPhoneContactInfoScreenButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"crazy_phone_contact_info_screen_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyPhoneContactInfoScreenButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        CrazyPhoneContactInfoScreenButtonMessage.writeTextState(message.textstate, buffer);
    }, buffer -> new CrazyPhoneContactInfoScreenButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), CrazyPhoneContactInfoScreenButtonMessage.readTextState(buffer)));

    public CustomPacketPayload.Type<CrazyPhoneContactInfoScreenButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CrazyPhoneContactInfoScreenButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                HashMap<String, String> textstate = message.textstate;
                CrazyPhoneContactInfoScreenButtonMessage.handleButtonAction(entity, buttonID, x, y, z, textstate);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.level();
        HashMap<String, Object> guistate = CrazyPhoneContactInfoScreenMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        String number = textstate.get("textin:number");
        if (number == null || number.isEmpty()) {
            return;
        }
        if (buttonID == 0) {
            String owner = GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)entity, null);
            if (owner != null && !owner.isEmpty()) {
                CrazyPhoneAddContactToPhoneProcedure.execute((LevelAccessor)world, number, owner);
                ScreenMenuUtils.openPhoneContactsMenu(entity, InteractionHand.MAIN_HAND);
            }
        } else if (buttonID == 1) {
            String string;
            StringTag _stringTag;
            CompoundTag phone;
            String name = "";
            String owner = "";
            Tag tag = CrazythingsModVariables.MapVariables.get((LevelAccessor)world).phones.get(number);
            if (tag instanceof CompoundTag) {
                CompoundTag _compoundTag = (CompoundTag)tag;
                v0 = _compoundTag.copy();
            } else {
                v0 = phone = new CompoundTag();
            }
            if (phone == null) {
                return;
            }
            tag = phone.get("name");
            if (tag instanceof StringTag) {
                _stringTag = (StringTag)tag;
                string = _stringTag.getAsString();
            } else {
                string = "";
            }
            name = string;
            tag = phone.get("uuid");
            if (tag instanceof StringTag) {
                _stringTag = (StringTag)tag;
                v2 = _stringTag.getAsString();
            } else {
                v2 = owner = "";
            }
            if (!name.isEmpty() && !owner.isEmpty() && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new UpdateContactInfoMessage(name, owner, number), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static void writeTextState(HashMap<String, String> map, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CrazyPhoneContactInfoScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getKey()));
            CrazyPhoneContactInfoScreenButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getValue()));
        }
    }

    private static HashMap<String, String> readTextState(RegistryFriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = CrazyPhoneContactInfoScreenButtonMessage.readComponent(buffer).getString();
            String value = CrazyPhoneContactInfoScreenButtonMessage.readComponent(buffer).getString();
            map.put(key, value);
        }
        return map;
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyPhoneContactInfoScreenButtonMessage::handleData);
    }
}

