/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.utils.ScreenMenuUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrazyPhoneAlbumClosedMessage() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrazyPhoneAlbumClosedMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"crazy_phone_album_closed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrazyPhoneAlbumClosedMessage> STREAM_CODEC = StreamCodec.unit((Object)new CrazyPhoneAlbumClosedMessage());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CrazyPhoneAlbumClosedMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player player = context.player();
                ScreenMenuUtils.openCurrentCrazyPhoneMenu(player, InteractionHand.MAIN_HAND);
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, CrazyPhoneAlbumClosedMessage::handle);
    }
}

