/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.network;

import net.mcreator.crazythings.CrazythingsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ClapAssParticlesMessage(double x, double y, double z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClapAssParticlesMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crazythings", (String)"clap_ass_particles"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClapAssParticlesMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeDouble(message.x);
        buffer.writeDouble(message.y);
        buffer.writeDouble(message.z);
    }, buffer -> new ClapAssParticlesMessage(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));

    public CustomPacketPayload.Type<ClapAssParticlesMessage> type() {
        return TYPE;
    }

    public static void handleData(ClapAssParticlesMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player == null) {
                return;
            }
            Vec3 particlePos = new Vec3(message.x, message.y, message.z);
            double distance = player.position().distanceTo(particlePos);
            if (distance > 30.0) {
                return;
            }
            int count = 30;
            double speed = 0.7;
            for (int i = 0; i < count; ++i) {
                double angle = Math.PI * 2 / (double)count * (double)i;
                double dx = Math.cos(angle);
                double dz = Math.sin(angle);
                mc.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, particlePos.x, particlePos.y, particlePos.z, dx * speed, 0.02, dz * speed);
            }
        });
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        CrazythingsMod.addNetworkMessage(TYPE, STREAM_CODEC, ClapAssParticlesMessage::handleData);
    }
}

