/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.mixin;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.net.PacketManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import net.mcreator.crazythings.utils.CameraModHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(value={PacketManager.class})
public abstract class CameraModPacketManagerMixin {
    @Accessor(value="clientDataMap")
    public abstract Map<UUID, byte[]> getClientDataMap();

    @Accessor(value="imageCache")
    public abstract Map<UUID, BufferedImage> getImageCache();

    @Overwrite
    public void addBytes(ServerPlayer player, UUID imageID, int offset, int length, byte[] bytes) {
        byte[] data = this.prepareOrGetByteArray(imageID, length);
        System.arraycopy(bytes, 0, data, offset, bytes.length);
        this.getClientDataMap().put(imageID, data);
        if (offset + bytes.length >= data.length) {
            this.handleImageCompletion(player, imageID);
        }
    }

    private byte[] prepareOrGetByteArray(UUID imageID, int length) {
        return this.getClientDataMap().getOrDefault(imageID, new byte[length]);
    }

    private void handleImageCompletion(ServerPlayer player, UUID imageID) {
        try {
            BufferedImage image = this.invokeCompleteImage(imageID);
            if (image == null) {
                throw new IOException("Image incomplete");
            }
            this.getImageCache().put(imageID, image);
            new Thread(() -> this.saveImageAndGiveItem(player, imageID, image), "SaveImageThread").start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BufferedImage invokeCompleteImage(UUID imageID) throws Exception {
        Method completeImageMethod = PacketManager.class.getDeclaredMethod("completeImage", UUID.class);
        completeImageMethod.setAccessible(true);
        return (BufferedImage)completeImageMethod.invoke((Object)this, imageID);
    }

    private void saveImageAndGiveItem(ServerPlayer player, UUID imageID, BufferedImage image) {
        try {
            ImageTools.saveImage((ServerPlayer)player, (UUID)imageID, (BufferedImage)image);
            player.getServer().submitAsync(() -> {
                ItemStack imageStack = new ItemStack((ItemLike)Main.IMAGE.get());
                ImageData imageData = ImageData.create((ServerPlayer)player, (UUID)imageID);
                imageData.addToImage(imageStack);
                if (CameraModHelper.tryInsertImageIntoCrazyPhone(player, imageStack)) {
                    return;
                }
                if (!player.addItem(imageStack)) {
                    Containers.dropItemStack((Level)player.level(), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)imageStack);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

