/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.mixin;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import de.maxhenkel.camera.ImageProcessor;
import de.maxhenkel.camera.ImageTaker;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ImageTaker.class})
public class CameraModImageTakerMixin {
    @Shadow
    private static boolean takeScreenshot;
    @Shadow
    private static UUID uuid;
    @Shadow
    private static boolean hide;
    @Unique
    private static int delayTicks;

    @Inject(method={"takeScreenshot"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectTakeScreenshot(UUID id, CallbackInfo ci) {
        if (!takeScreenshot || !id.equals(uuid)) {
            Minecraft mc = Minecraft.getInstance();
            hide = mc.options.hideGui;
            mc.options.hideGui = true;
            uuid = id;
            delayTicks = 40;
            takeScreenshot = true;
            mc.setScreen((Screen)null);
        } else {
            ci.cancel();
        }
    }

    @Inject(method={"onRenderTickEnd"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectOnRenderTickEnd(RenderFrameEvent.Post event, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (takeScreenshot) {
            if (mc.screen != null || !mc.options.hideGui) {
                ci.cancel();
                return;
            }
            NativeImage image = Screenshot.takeScreenshot((RenderTarget)mc.getMainRenderTarget());
            mc.options.hideGui = hide;
            takeScreenshot = false;
            ImageProcessor.sendScreenshotThreaded((UUID)uuid, (NativeImage)image);
            ci.cancel();
        }
    }

    static {
        delayTicks = 0;
    }
}

