/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.mixin;

import de.maxhenkel.camera.ClientEvents;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.CameraItem;
import net.mcreator.crazythings.mixin.ImageTakerAccessor;
import net.mcreator.crazythings.utils.CameraModHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientEvents.class})
public abstract class CameraModClientEventsMixin {
    @Inject(method={"getActiveCamera"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectGetActiveCamera(CallbackInfoReturnable<ItemStack> cir) {
        if (cir.getReturnValue() != null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = mc.player.getItemInHand(hand);
            if (!CameraModHelper.isSupportedCamera(stack) || !((CameraItem)Main.CAMERA.get()).isActive(stack)) continue;
            cir.setReturnValue((Object)stack);
            return;
        }
    }

    @Inject(method={"renderPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderPlayer(RenderPlayerEvent.Pre event, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        for (AbstractClientPlayer player : level.players()) {
            if (player == mc.player) continue;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.getItemInHand(hand);
                if (!CameraModHelper.isSupportedCamera(stack)) continue;
                if (((CameraItem)Main.CAMERA.get()).isActive(stack)) {
                    player.startUsingItem(hand);
                    continue;
                }
                player.stopUsingItem();
            }
        }
        ci.cancel();
    }

    @Inject(method={"renderOverlay"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRenderOverlay(RenderGuiLayerEvent.Pre event, CallbackInfo ci) {
        if (ImageTakerAccessor.getTakeScreenshot()) {
            event.setCanceled(true);
            ci.cancel();
        }
    }
}

