/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.managers;

import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import java.util.Optional;
import java.util.UUID;

public class VoiceChatManager {
    private final VoicechatServerApi api;

    public VoiceChatManager(VoicechatServerApi api) {
        this.api = api;
    }

    public Group createGroup(String name, String password, boolean persistent, Group.Type type) {
        return this.api.groupBuilder().setName(name).setPassword(password).setPersistent(persistent).setHidden(false).setType(type).build();
    }

    public Optional<Group> getGroupByName(String name) {
        return this.api.getGroups().stream().filter(group -> group.getName().equals(name)).findFirst();
    }

    public boolean removeGroup(String name) {
        Optional<Group> group = this.getGroupByName(name);
        return group.map(g -> this.api.removeGroup(g.getId())).orElse(false);
    }

    public boolean isGroupEmpty(String name) {
        return this.getGroupByName(name).map(group -> this.api.getGroups().stream().noneMatch(g -> g.getId().equals(group.getId()))).orElse(true);
    }

    public boolean addPlayerToGroup(UUID playerUUID, String groupName) {
        Optional<Group> groupOpt = this.getGroupByName(groupName);
        Group group = null;
        group = groupOpt.isEmpty() ? this.createGroup(groupName, "1234", false, Group.Type.OPEN) : groupOpt.get();
        if (group == null) {
            return false;
        }
        VoicechatConnection connection = this.api.getConnectionOf(playerUUID);
        if (connection == null) {
            return false;
        }
        connection.setGroup(group);
        return true;
    }

    public boolean removePlayerFromGroup(UUID playerUUID) {
        VoicechatConnection connection = this.api.getConnectionOf(playerUUID);
        if (connection == null || connection.getGroup() == null) {
            return false;
        }
        Group group = connection.getGroup();
        connection.setGroup(null);
        if (group != null && this.isGroupEmpty(group.getName())) {
            return this.api.removeGroup(group.getId());
        }
        return true;
    }

    public boolean isPlayerInGroup(UUID playerUUID, String groupName) {
        Group group;
        VoicechatConnection connection = this.api.getConnectionOf(playerUUID);
        if (connection == null || !((group = connection.getGroup()) instanceof Group)) {
            return false;
        }
        Group group2 = group;
        return group2.getName().equals(groupName);
    }

    public boolean removePlayerFromSpecificGroup(UUID playerUUID, String groupName) {
        if (!this.isPlayerInGroup(playerUUID, groupName)) {
            return false;
        }
        return this.removePlayerFromGroup(playerUUID);
    }
}

