/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.item;

import java.util.function.Consumer;
import net.mcreator.crazythings.item.renderer.EmboutDeChichaItemRenderer;
import net.mcreator.crazythings.procedures.EmboutDeChichaItemInInventoryTickProcedure;
import net.mcreator.crazythings.procedures.EmboutDeChichaOnPlayerStoppedUsingProcedure;
import net.mcreator.crazythings.procedures.EmboutDeChichaRightclickedOnBlockProcedure;
import net.mcreator.crazythings.procedures.EmboutDeChichaRightclickedProcedure;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EmboutDeChichaItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public String animationprocedure = "empty";
    public static EnumProxy<HumanoidModel.ArmPose> ARM_POSE = EmboutDeChichaItem.isClientRuntime() ? EmboutDeChichaItem.createPoseProxy() : null;
    String prevAnim = "empty";

    public EmboutDeChichaItem() {
        super(new Item.Properties().stacksTo(64).rarity(Rarity.UNCOMMON));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private EmboutDeChichaItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new EmboutDeChichaItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static EnumProxy<HumanoidModel.ArmPose> createPoseProxy() {
        return new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{false, (model, entity, arm) -> {
            if (arm == HumanoidArm.LEFT) {
                model.leftArm.xRot = model.leftArm.xRot + 50.0f + model.head.xRot;
            }
        }});
    }

    private static boolean isClientRuntime() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack item, int count) {
        super.onUseTick(level, entity, item, count);
        Level world = entity.level();
        if (!world.isClientSide && count % 20 == 0) {
            world.playSound(null, entity.blockPosition(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"crazythings:taf-chicha")), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(this){

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.isEmpty() && entityLiving.getUsedItemHand() == hand) {
                    return (HumanoidModel.ArmPose)ARM_POSE.getValue();
                }
                return HumanoidModel.ArmPose.EMPTY;
            }
        });
    }

    private PlayState idlePredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController procedureController = new AnimationController((GeoAnimatable)this, "procedureController", 0, this::procedurePredicate);
        data.add(procedureController);
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 0, this::idlePredicate);
        data.add(idleController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 260;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        EmboutDeChichaRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (ItemStack)ar.getObject());
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        EmboutDeChichaOnPlayerStoppedUsingProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack, 1.0);
        return retval;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        return EmboutDeChichaRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), context.getPlayer(), context.getItemInHand());
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        EmboutDeChichaItemInInventoryTickProcedure.execute(entity, itemstack, slot);
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, Player entity) {
        EmboutDeChichaOnPlayerStoppedUsingProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack, 1.0);
        return true;
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        EmboutDeChichaOnPlayerStoppedUsingProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack, 1.0);
    }
}

