/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.item;

import net.mcreator.crazythings.CrazythingsMod;
import net.mcreator.crazythings.init.CrazythingsModItems;
import net.mcreator.crazythings.item.LaserGunItem;
import net.mcreator.crazythings.procedures.LaserGunRightclickedProcedure;
import net.mcreator.crazythings.utils.LaserGameDataHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;

public class ActivatedLaserGunItem
extends LaserGunItem {
    private Vec3 laserColor = new Vec3(1.0, 1.0, 1.0);

    public Vec3 getLaserColor() {
        return this.laserColor;
    }

    public void setLaserColor(Vec3 laserColor) {
        this.laserColor = laserColor;
    }

    @Override
    protected void handleShoot(Level world, Player shooter) {
        if (world.isClientSide || shooter.getCooldowns().isOnCooldown((Item)this)) {
            return;
        }
        double nbShoots = LaserGameDataHelper.getLaserGameNbShoots((Entity)shooter);
        LaserGameDataHelper.setLaserGameNbShoots((Entity)shooter, nbShoots + 1.0);
        Entity victim = this.shootAndGetVictim(world, shooter);
        shooter.getCooldowns().addCooldown((Item)this, 8);
        if (victim == null) {
            return;
        }
        PlayerTeam shooterTeam = this.getTeam(world, (Entity)shooter);
        PlayerTeam victimTeam = this.getTeam(world, victim);
        if (shooterTeam == null || victimTeam == null || shooterTeam == victimTeam) {
            return;
        }
        this.handleHit(world, (Entity)shooter, victim, victimTeam);
    }

    private Entity shootAndGetVictim(Level world, Player shooter) {
        return LaserGunRightclickedProcedure.fireLaser((LevelAccessor)world, (Entity)shooter, this::isValidTarget, this.laserColor, true);
    }

    protected boolean isValidTarget(Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Player player = (Player)e;
        ItemStack chestplate = (ItemStack)player.getInventory().armor.get(2);
        return chestplate == null || chestplate.getItem() != CrazythingsModItems.LASER_GAME_ARMOR_CHESTPLATE.get();
    }

    private PlayerTeam getTeam(Level world, Entity player) {
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        return serverLevel.getScoreboard().getPlayersTeam(player.getScoreboardName());
    }

    private void handleHit(Level world, Entity shooter, Entity victim, PlayerTeam victimTeam) {
        double lives = LaserGameDataHelper.getLaserGameNbLives(victim);
        LaserGameDataHelper.setLaserGameNbLives(victim, lives - 1.0);
        String victimName = victim.getCustomName() != null ? victim.getCustomName().getString() : victim.getName().getString();
        LaserGameDataHelper.addLaserGameShoot(shooter, victimName);
        double maxLives = LaserGameDataHelper.getLaserGameNbMaxLives((LevelAccessor)world);
        if (victim instanceof Player) {
            this.disablePlayerGear((Player)victim);
        }
        if (LaserGameDataHelper.getLaserGameNbLives(victim) <= 0.0 && maxLives > 0.0) {
            Vec3 base = LaserGameDataHelper.getLaserGameBase(victim);
            if (!base.equals((Object)Vec3.ZERO)) {
                victim.teleportTo(base.x, base.y, base.z);
            }
            LaserGameDataHelper.setLaserGameNbLives(victim, maxLives);
        }
        LaserGameDataHelper.sync((LevelAccessor)world);
        if (shooter instanceof Player) {
            ((Player)shooter).sendSystemMessage((Component)Component.literal((String)(victim.getName().getString() + " hit!")));
        }
        world.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
        if (victim instanceof Player) {
            CrazythingsMod.queueServerWork(80, () -> this.reenablePlayerGear((Player)victim, victimTeam));
        }
    }

    private void disablePlayerGear(Player victim) {
        victim.getInventory().armor.set(2, (Object)new ItemStack((ItemLike)CrazythingsModItems.LASER_GAME_ARMOR_CHESTPLATE.get()));
        ActivatedLaserGunItem.replaceGunInHotbar(victim, (Item)CrazythingsModItems.CYAN_LASER_GUN.get(), (Item)CrazythingsModItems.LASER_GUN.get());
        ActivatedLaserGunItem.replaceGunInHotbar(victim, (Item)CrazythingsModItems.RED_LASER_GUN.get(), (Item)CrazythingsModItems.LASER_GUN.get());
    }

    private void reenablePlayerGear(Player victim, PlayerTeam victimTeam) {
        if (victimTeam == null) {
            return;
        }
        String teamName = victimTeam.getName();
        if (teamName.contains("cyan")) {
            victim.getInventory().armor.set(2, (Object)new ItemStack((ItemLike)CrazythingsModItems.CYAN_LASER_GAME_ARMOR_CHESTPLATE.get()));
            ActivatedLaserGunItem.replaceGunInHotbar(victim, (Item)CrazythingsModItems.LASER_GUN.get(), (Item)CrazythingsModItems.CYAN_LASER_GUN.get());
        } else if (teamName.contains("red")) {
            victim.getInventory().armor.set(2, (Object)new ItemStack((ItemLike)CrazythingsModItems.RED_LASER_GAME_ARMOR_CHESTPLATE.get()));
            ActivatedLaserGunItem.replaceGunInHotbar(victim, (Item)CrazythingsModItems.LASER_GUN.get(), (Item)CrazythingsModItems.RED_LASER_GUN.get());
        }
    }

    public static void replaceGunInHotbar(Player player, Item gunToFind, Item gunToSet) {
        for (int slot = 0; slot <= 8; ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack == null || stack.getItem() != gunToFind) continue;
            player.getInventory().setItem(slot, new ItemStack((ItemLike)gunToSet));
            return;
        }
    }
}

