/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.entity;

import javax.annotation.Nullable;
import net.mcreator.crazythings.init.CrazythingsModEntities;
import net.mcreator.crazythings.init.CrazythingsModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class TchollnirEntityEntity
extends Projectile
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)CrazythingsModItems.TCHOLLNIR.get());
    private int knockback = 0;
    private int ticksInAir = 5;
    private boolean returning = false;
    private Player thrower;

    public void setThrower(LivingEntity entity) {
        if (entity instanceof Player) {
            this.thrower = (Player)entity;
        }
    }

    public TchollnirEntityEntity(EntityType<? extends TchollnirEntityEntity> type, Level world) {
        super(type, world);
    }

    public TchollnirEntityEntity(EntityType<? extends TchollnirEntityEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, world);
    }

    public TchollnirEntityEntity(EntityType<? extends TchollnirEntityEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (result.getEntity() == this.thrower) {
            return;
        }
        super.onHitEntity(result);
    }

    public void tick() {
        Vec3 newPos = this.position().add(this.getDeltaMovement());
        this.setPos(newPos);
        if (this.level().isClientSide) {
            return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir >= 30 && !this.returning) {
            this.returning = true;
        }
        if (this.returning) {
            if (this.thrower != null && !this.thrower.isRemoved()) {
                Vec3 toPlayer = new Vec3(this.thrower.getX() - this.getX(), this.thrower.getY() + (double)(this.thrower.getEyeHeight() / 2.0f) - this.getY(), this.thrower.getZ() - this.getZ());
                this.setDeltaMovement(toPlayer.normalize().scale(0.8));
                double distance = this.distanceTo((Entity)this.thrower);
                if (distance < 1.0) {
                    ItemStack tchollnir = new ItemStack((ItemLike)CrazythingsModItems.TCHOLLNIR.get());
                    if (this.thrower.getMainHandItem().isEmpty()) {
                        this.thrower.setItemInHand(InteractionHand.MAIN_HAND, tchollnir);
                    } else if (!this.thrower.getInventory().add(tchollnir)) {
                        this.thrower.spawnAtLocation(tchollnir);
                    }
                    this.discard();
                }
            } else {
                this.discard();
            }
        } else if (this.thrower != null && !this.thrower.isRemoved()) {
            Vec3 look = this.thrower.getViewVector(1.0f).normalize();
            this.setDeltaMovement(look);
        }
        if (this.ticksInAir % 10 == 0 && this.thrower != null) {
            LightningBolt lightning;
            Vec3 pos = this.position();
            if (this.thrower.distanceToSqr(pos.x, pos.y, pos.z) > 6.0 && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level())) != null) {
                lightning.moveTo(pos.x, pos.y, pos.z);
                this.level().addFreshEntity((Entity)lightning);
            }
        }
    }

    public static TchollnirEntityEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return TchollnirEntityEntity.shoot(world, entity, source, 1.5f, 8.0, 10);
    }

    public static TchollnirEntityEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return TchollnirEntityEntity.shoot(world, entity, source, 1.5f, 8.0, 10);
    }

    public static TchollnirEntityEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        TchollnirEntityEntity entityarrow = new TchollnirEntityEntity((EntityType<? extends TchollnirEntityEntity>)((EntityType)CrazythingsModEntities.TCHOLLNIR_ENTITY.get()), entity, world, null);
        Vec3 look = entity.getViewVector(1.0f).normalize().scale((double)power);
        entityarrow.setDeltaMovement(look);
        entityarrow.shoot(look.x, look.y, look.z, 1.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setKnockback(knockback);
        entityarrow.setThrower(entity);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        Vec3 startPos = entity.position().add(look.scale(1.0));
        entityarrow.setPos(startPos.x, startPos.y + (double)entity.getEyeHeight() * 0.5, startPos.z);
        return entityarrow;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }
}

