/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.screens;

import de.maxhenkel.camera.gui.AlbumScreen;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class BoosterAlbumScreen
extends AlbumScreen {
    private List<ItemStack> itemStacks;
    private Rarity lastRarity;

    public BoosterAlbumScreen(List<UUID> images, List<ItemStack> itemStacks) {
        super(images);
        this.itemStacks = itemStacks;
        this.lastRarity = null;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ItemStack currentStack;
        Rarity currentRarity;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.itemStacks.isEmpty() && this.index >= 0 && this.index < this.itemStacks.size() && this.lastRarity != (currentRarity = (currentStack = this.itemStacks.get(this.index)).getRarity())) {
            this.playRaritySound(currentRarity);
            this.lastRarity = currentRarity;
        }
    }

    private void playRaritySound(Rarity rarity) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        switch (rarity) {
            case EPIC: {
                Minecraft.getInstance().player.playNotifySound(SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.MASTER, 1.0f, 1.0f);
                break;
            }
            case RARE: {
                Minecraft.getInstance().player.playNotifySound(SoundEvents.EVOKER_PREPARE_WOLOLO, SoundSource.MASTER, 1.0f, 1.0f);
                break;
            }
        }
    }
}

