/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui.components;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class WrappedTextWidget
extends AbstractWidget {
    private final Font font;
    private final float textScale;
    private int textColor = 0xFFFFFF;
    private int backgroundColor = Integer.MIN_VALUE;
    private final int paddingLeft;
    private final int paddingRight;
    private final int paddingTop;
    private final int paddingBottom;
    private int minHeight = 0;

    public WrappedTextWidget(Font font, int x, int y, int width, Component message, float textScale, int textColor, int backgroundColor, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        super(x, y, width, 0, message);
        this.font = font;
        this.textScale = textScale;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.height = this.calculateHeight();
    }

    public WrappedTextWidget(Font font, int x, int y, int width, Component message, float textScale, int textColor, int backgroundColor) {
        this(font, x, y, width, message, textScale, textColor, backgroundColor, 3, 3, 4, 3);
    }

    private int calculateHeight() {
        int effectiveWidth = (int)((float)(this.width - this.paddingLeft - this.paddingRight) / this.textScale);
        List lines = this.font.split((FormattedText)this.getMessage(), effectiveWidth);
        int n = Math.max(1, lines.size());
        Objects.requireNonNull(this.font);
        int textHeight = Math.round((float)(n * 9) * this.textScale) + this.paddingTop + this.paddingBottom;
        return Math.max(this.minHeight, textHeight);
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        this.height = this.calculateHeight();
    }

    public void setMessage(Component message) {
        super.setMessage(message);
        this.height = this.calculateHeight();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int renderX = this.getX();
        int renderY = this.getY();
        int renderWidth = this.width;
        int renderHeight = this.height;
        guiGraphics.fill(renderX, renderY, renderX + renderWidth, renderY + renderHeight, this.backgroundColor);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(this.textScale, this.textScale, 1.0f);
        List lines = this.font.split((FormattedText)this.getMessage(), (int)((float)(this.width - this.paddingLeft - this.paddingRight) / this.textScale));
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            int n = (int)((float)(this.getY() + this.paddingTop) / this.textScale);
            Objects.requireNonNull(this.font);
            int lineY = n + i * 9;
            Objects.requireNonNull(this.font);
            if (!((float)(lineY + 9) > (float)renderY / this.textScale) || !((float)lineY < (float)(renderY + renderHeight) / this.textScale)) continue;
            guiGraphics.drawString(this.font, line, (int)((float)(this.getX() + this.paddingLeft) / this.textScale), lineY, this.textColor, false);
        }
        guiGraphics.pose().popPose();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

