/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui.components;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.gui.ImageScreen;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.crazythings.client.gui.components.MessageDisplayManager;
import net.mcreator.crazythings.client.gui.components.WrappedTextWidget;
import net.mcreator.crazythings.utils.CameraModHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class MessageWidget
extends AbstractWidget {
    private final WrappedTextWidget wrappedText;
    private final boolean isSender;
    private final ItemStack icon;
    private int scrollPosition;
    private int adjustedY;
    boolean showIcon = true;
    private ItemStack image = ItemStack.EMPTY;
    private int imageWidth = 0;
    private int imageHeight = 0;
    MessageDisplayManager manager;

    public MessageWidget(WrappedTextWidget wrappedText, boolean isSender, ItemStack icon, int scrollPosition, @Nullable ItemStack image, MessageDisplayManager messageDisplayManager) {
        super(wrappedText.getX(), wrappedText.getY(), wrappedText.getWidth(), wrappedText.getHeight(), wrappedText.getMessage());
        this.wrappedText = wrappedText;
        this.isSender = isSender;
        this.icon = icon;
        this.scrollPosition = scrollPosition;
        this.manager = messageDisplayManager;
        if (image != null && !image.isEmpty()) {
            this.image = image;
            this.initImageScaling();
        }
        this.adjustPosition(this.getX() + (isSender ? 0 : 15));
    }

    public void setScrollPosition(int scrollPosition) {
        this.scrollPosition = scrollPosition;
        this.adjustPosition();
    }

    public void adjustPosition() {
        this.adjustPosition(this.wrappedText.getX());
    }

    private void adjustPosition(int x) {
        this.adjustedY = this.getY() + this.scrollPosition - this.wrappedText.getHeight();
        this.wrappedText.setPosition(x, this.adjustedY);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.wrappedText.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderItemHead(guiGraphics);
        if (!this.image.isEmpty()) {
            this.renderImage(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderItemHead(GuiGraphics guiGraphics) {
        int itemX = this.isSender ? this.wrappedText.getX() + this.wrappedText.getWidth() : this.wrappedText.getX() - 17;
        int itemY = this.wrappedText.getY() + this.wrappedText.getHeight() - 16;
        if (this.showIcon) {
            guiGraphics.renderItem(this.icon, itemX, itemY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.image.isEmpty()) {
            int x = this.wrappedText.getX();
            int y = this.wrappedText.getY();
            if (mouseX >= (double)x && mouseX < (double)(x + this.imageWidth) && mouseY >= (double)y && mouseY < (double)(y + this.imageHeight)) {
                this.onImageClick(button);
                return true;
            }
        }
        return false;
    }

    private void onImageClick(int button) {
        if (button == 0) {
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (localPlayer instanceof LocalPlayer) {
                LocalPlayer localPlayer2 = localPlayer;
                localPlayer2.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            }
            CameraModHelper.openImage(this.image);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new ImageScreen(stack));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setShowIcon(boolean b) {
        this.showIcon = b;
    }

    private void renderImage(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ImageData imageData;
        if (this.image.isEmpty()) {
            return;
        }
        if (this.imageWidth <= 0 || this.imageHeight <= 0) {
            this.initImageScaling();
            this.adjustPosition();
            this.manager.resetPositions();
        }
        if ((imageData = ImageData.fromStack((ItemStack)this.image)) == null) {
            return;
        }
        UUID imageID = imageData.getId();
        if (imageID == null) {
            return;
        }
        int x = this.wrappedText.getX();
        int y = this.wrappedText.getY();
        MessageWidget.drawImage(guiGraphics, Minecraft.getInstance(), x, y + 1, this.imageWidth, this.imageHeight - 2, 0.0f, imageID, mouseX >= x && mouseX < x + this.imageWidth && mouseY >= y && mouseY < y + this.imageHeight ? 2 : 0);
    }

    public void initImageScaling() {
        ImageData imageData = ImageData.fromStack((ItemStack)this.image);
        if (imageData != null) {
            UUID imageID = imageData.getId();
            NativeImage nativeImage = TextureCache.instance().getNativeImage(imageID);
            if (nativeImage != null) {
                int maxWidth;
                float imgWidth = nativeImage.getWidth();
                float imgHeight = nativeImage.getHeight();
                this.imageWidth = maxWidth = this.wrappedText.getWidth();
                this.imageHeight = (int)((float)maxWidth * imgHeight / imgWidth);
                this.wrappedText.setMinHeight(Math.max(18, this.imageHeight));
                this.setHeight(this.wrappedText.getHeight());
            }
        }
    }

    public static void drawImage(GuiGraphics guiGraphics, Minecraft minecraft, int x, int y, int width, int height, float zLevel, UUID uuid, int degreeRotateAngle) {
        float hnew;
        float wnew;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        float angleRadians = (float)Math.toRadians(degreeRotateAngle);
        guiGraphics.pose().translate((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotation(angleRadians));
        guiGraphics.pose().translate((float)(-width) / 2.0f, (float)(-height) / 2.0f, degreeRotateAngle > 0 ? 10.0f : 0.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation location = TextureCache.instance().getImage(uuid);
        float imageWidth = 12.0f;
        float imageHeight = 8.0f;
        if (location == null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ImageScreen.DEFAULT_IMAGE);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            NativeImage image = TextureCache.instance().getNativeImage(uuid);
            if (image != null) {
                imageWidth = image.getWidth();
                imageHeight = image.getHeight();
            }
        }
        float ws = width;
        float hs = height;
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float left = (ws - wnew) / 2.0f;
        float top = (hs - hnew) / 2.0f;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, left, top, zLevel).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, left, top + hnew, zLevel).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, left + wnew, top + hnew, zLevel).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, left + wnew, top, zLevel).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        guiGraphics.pose().popPose();
    }
}

