/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.mcreator.crazythings.client.gui.components.MessageData;
import net.mcreator.crazythings.client.gui.components.MessageWidget;
import net.mcreator.crazythings.client.gui.components.WrappedTextWidget;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MessageDisplayManager {
    private final List<MessageEntry> messageEntries = new ArrayList<MessageEntry>();
    private final int x;
    private final int y;
    private final int width;
    private final float scale;
    private int scrollOffset = 0;
    private int PADDING = 5;
    private List<Contact> contacts;
    private HashMap<String, ItemStack> icons = new HashMap();
    private String ownerNumber;
    private int totalHeight = 0;

    public MessageDisplayManager(int x, int y, int width, float scale, List<Contact> contacts, String ownerNumber) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.scale = scale;
        this.contacts = contacts;
        this.ownerNumber = ownerNumber;
        for (Contact contact : contacts) {
            this.icons.put(contact.getNumber(), CrazyPhoneHelper.createContactHead(contact));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (MessageEntry entry : this.messageEntries) {
            entry.widget.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void resetPositions() {
        int currentY = this.y + this.scrollOffset;
        this.totalHeight = 0;
        String previousSender = null;
        for (int i = 0; i < this.messageEntries.size(); ++i) {
            MessageEntry currentEntry = this.messageEntries.get(i);
            String currentSender = currentEntry.data().getSender();
            String nextSender = i + 1 < this.messageEntries.size() ? this.messageEntries.get(i + 1).data().getSender() : null;
            boolean sameAsNext = currentSender.equals(nextSender);
            boolean sameAsPrevious = currentSender.equals(previousSender);
            currentEntry.widget.setY(currentY);
            currentEntry.widget.setShowIcon(!sameAsPrevious);
            currentEntry.widget.adjustPosition();
            int paddingBelow = sameAsNext ? 0 : this.PADDING;
            currentY -= currentEntry.widget.getHeight() + paddingBelow;
            this.totalHeight += currentEntry.widget.getHeight() + paddingBelow;
            previousSender = currentSender;
        }
    }

    public void setScrollOffset(int offset) {
        this.scrollOffset = offset;
        this.resetPositions();
    }

    public MessageEntry addMessage(MessageData newMessage) {
        boolean isSender = this.ownerNumber.equals(newMessage.getSender());
        WrappedTextWidget wrapped = new WrappedTextWidget(Minecraft.getInstance().font, this.x, 0, this.width, (Component)Component.literal((String)newMessage.getMessage()), this.scale, !isSender ? -16777216 : -1, newMessage.getMessage().isBlank() ? 0xFFFFFF : (!isSender ? -855966982 : -872381185));
        ItemStack icon = this.icons.get(newMessage.getSender());
        if (icon == null) {
            icon = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        }
        MessageWidget widget = new MessageWidget(wrapped, isSender, icon, 0, newMessage.getImage(), this);
        MessageEntry entry = new MessageEntry(newMessage, widget);
        this.messageEntries.add(0, entry);
        this.resetPositions();
        return entry;
    }

    public void clearMessages() {
        this.messageEntries.clear();
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public List<MessageEntry> getMessages() {
        return this.messageEntries;
    }

    public record MessageEntry(MessageData data, MessageWidget widget) {
    }
}

