/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import java.util.HashMap;
import net.mcreator.crazythings.init.CrazythingsModScreens;
import net.mcreator.crazythings.network.ScratchTicketInterfaceButtonMessage;
import net.mcreator.crazythings.world.inventory.ScratchTicketInterfaceMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ScratchTicketInterfaceScreen
extends AbstractContainerScreen<ScratchTicketInterfaceMenu>
implements CrazythingsModScreens.WidgetScreen {
    private static final HashMap<String, Object> guistate = ScratchTicketInterfaceMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private final ItemStack itemstack;
    private int ticketX;
    private int ticketY;
    private int ticketWidth;
    private int ticketHeight;
    private static final float SCRATCH_START_X = 0.2f;
    private static final float SCRATCH_START_Y = 0.35f;
    private static final float SCRATCH_WIDTH = 0.5f;
    private static final float SCRATCH_HEIGHT = 0.5f;
    private boolean scratched = false;
    private int isWinning = 0;
    private final ResourceLocation TEXTURE_DEFAULT = ResourceLocation.parse((String)"crazythings:textures/screens/scratch-ticket-default.png");
    private final ResourceLocation TEXTURE_SCRATCHED = ResourceLocation.parse((String)"crazythings:textures/screens/scratch-ticket-scratched.png");

    public void setScratched(boolean scratched) {
        this.scratched = scratched;
    }

    public void setWinning(int isWinning) {
        this.isWinning = isWinning;
    }

    public ScratchTicketInterfaceScreen(ScratchTicketInterfaceMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.itemstack = this.entity.getMainHandItem();
    }

    protected void init() {
        super.init();
        this.calculateTicketDimensions();
        CompoundTag tag = ((CustomData)this.itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        this.scratched = tag.contains("scratched") ? tag.getBoolean("scratched") : false;
        this.isWinning = tag.contains("isWinning") ? tag.getInt("isWinning") : 0;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float mouseX, int mouseY, int partialTicks) {
        ResourceLocation background = this.getBackgroundTexture();
        guiGraphics.blit(background, this.ticketX, this.ticketY, 0.0f, 0.0f, this.ticketWidth, this.ticketHeight, this.ticketWidth, this.ticketHeight);
        if (this.scratched) {
            String winText = this.isWinning > 0 ? this.isWinning + " Cc" : "Perdu !";
            float scale = (float)this.ticketHeight / 150.0f;
            float posXPercent = 0.5f;
            float posYPercent = 0.55f;
            int textWidth = this.font.width(winText);
            int textX = this.ticketX + (int)((float)this.ticketWidth * posXPercent) - (int)((float)textWidth * scale / 2.0f);
            int textY = this.ticketY + (int)((float)this.ticketHeight * posYPercent);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(textX + 2), (float)textY, 0.0f);
            guiGraphics.pose().scale(scale, scale, 1.0f);
            guiGraphics.drawString(this.font, winText, 0, 0, 984832, false);
            guiGraphics.pose().popPose();
        }
    }

    private void calculateTicketDimensions() {
        int screenHeight = this.height;
        this.ticketHeight = (int)((double)screenHeight * 0.8);
        this.ticketWidth = (int)((float)this.ticketHeight * 0.8064516f);
        this.ticketX = (this.width - this.ticketWidth) / 2;
        this.ticketY = (this.height - this.ticketHeight) / 2;
    }

    private ResourceLocation getBackgroundTexture() {
        return this.scratched ? this.TEXTURE_SCRATCHED : this.TEXTURE_DEFAULT;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scratched) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.isInScratchZone(mouseX, mouseY)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ScratchTicketInterfaceButtonMessage(0, this.x, this.y, this.z, new HashMap<String, String>()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isInScratchZone(double mouseX, double mouseY) {
        int zoneX = (int)((float)this.ticketX + (float)this.ticketWidth * 0.2f);
        int zoneY = (int)((float)this.ticketY + (float)this.ticketHeight * 0.35f);
        int zoneW = (int)((float)this.ticketWidth * 0.5f);
        int zoneH = (int)((float)this.ticketHeight * 0.5f);
        return mouseX >= (double)zoneX && mouseX <= (double)(zoneX + zoneW) && mouseY >= (double)zoneY && mouseY <= (double)(zoneY + zoneH);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        this.minecraft.player.closeContainer();
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return null;
    }
}

