/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mcreator.crazythings.client.gui.CrazyPhoneDefaultScreenScreen;
import net.mcreator.crazythings.network.CrazyPhonePicturesScreenButtonMessage;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.utils.CameraModHelper;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.utils.ScreenMenuUtils;
import net.mcreator.crazythings.world.inventory.CrazyPhonePicturesScreenMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyPhonePicturesScreenScreen
extends CrazyPhoneDefaultScreenScreen<CrazyPhonePicturesScreenMenu> {
    private static final HashMap<String, Object> guistate = CrazyPhonePicturesScreenMenu.guistate;
    Button button_retour;
    Button button_del;
    Button button_take;
    Button button_send;
    boolean isSendMode = false;
    private final Set<Integer> selectedSlots = new HashSet<Integer>();
    public int albumId;

    public CrazyPhonePicturesScreenScreen(CrazyPhonePicturesScreenMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
        String potentialConversationPage;
        this.albumId = container.albumId;
        CrazythingsModVariables.PlayerVariables playerData = (CrazythingsModVariables.PlayerVariables)this.entity.getData(CrazythingsModVariables.PLAYER_VARIABLES);
        List<String> screenHistory = ScreenMenuUtils.getScreenHistory(playerData.crazyPhoneScreenHistory);
        if (screenHistory.size() >= 3 && (potentialConversationPage = screenHistory.get(screenHistory.size() - 3)).contains("crazy_phone_conversation")) {
            this.isSendMode = true;
        }
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return guistate;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        super.renderBg(guiGraphics, partialTicks, gx, gy);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int index : this.selectedSlots) {
            Slot slot = (Slot)((CrazyPhonePicturesScreenMenu)this.menu).get().get(index);
            if (slot == null) continue;
            int x = this.leftPos + slot.x;
            int y = this.topPos + slot.y;
            guiGraphics.blit(ResourceLocation.parse((String)"crazythings:textures/screens/slot_selected.png"), x - 1, y - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        RenderSystem.disableBlend();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (Map.Entry entry : ((CrazyPhonePicturesScreenMenu)this.menu).get().entrySet()) {
            ItemStack stack;
            ItemStack itemStack;
            Slot slot = (Slot)entry.getValue();
            if (!this.isHoveringSlot(slot, mouseX, mouseY) || !((itemStack = slot.getItem()) instanceof ItemStack) || (stack = itemStack).isEmpty()) continue;
            int index = (Integer)entry.getKey();
            if (button == 1) {
                this.playToggleSound();
                if (!this.selectedSlots.add(index)) {
                    this.selectedSlots.remove(index);
                }
                return true;
            }
            if (button != 0) continue;
            this.onSlotLeftClick(index);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void onSlotLeftClick(int index) {
        IItemHandlerModifiable handler = CrazyPhoneHelper.getPhoneItemHandler(this.entity);
        ItemStack albumStack = CrazyPhoneHelper.getAlbumFromPhoneHandler(handler, this.albumId);
        int alteredIndex = this.adjustIndexByIgnoringEmptySlots(index);
        CameraModHelper.openAlbum(this.entity, albumStack, alteredIndex);
    }

    private int adjustIndexByIgnoringEmptySlots(int originalIndex) {
        int emptySlot = 0;
        for (int i = 0; i < originalIndex; ++i) {
            if (!((CrazyPhonePicturesScreenMenu)this.menu).internal.getStackInSlot(i).isEmpty()) continue;
            ++emptySlot;
        }
        return originalIndex - emptySlot;
    }

    private boolean isHoveringSlot(Slot slot, double mouseX, double mouseY) {
        int x = this.leftPos + slot.x;
        int y = this.topPos + slot.y;
        return mouseX >= (double)x && mouseX < (double)(x + 16) && mouseY >= (double)y && mouseY < (double)(y + 16);
    }

    @Override
    public void init() {
        super.init();
        if (this.isSendMode) {
            this.button_send = Button.builder((Component)Component.translatable((String)"gui.crazythings.crazy_phone_pictures_screen.button_send"), e -> {
                if (!this.selectedSlots.isEmpty()) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    StringBuilder slotList = new StringBuilder();
                    for (int i : this.selectedSlots) {
                        if (slotList.length() > 0) {
                            slotList.append(",");
                        }
                        slotList.append(i);
                    }
                    values.put("selectedSlots", slotList.toString());
                    values.put("albumIndex", String.valueOf(this.albumId));
                    PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhonePicturesScreenButtonMessage(2, this.x, this.y, this.z, values), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    Minecraft.getInstance().player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                }
                this.selectedSlots.clear();
            }).bounds(this.leftPos + 6, this.topPos + 154, 110, 20).build();
            guistate.put("button:button_send", this.button_send);
            this.addRenderableWidget((GuiEventListener)this.button_send);
        } else {
            this.button_del = Button.builder((Component)Component.translatable((String)"gui.crazythings.crazy_phone_pictures_screen.button_delete"), e -> {
                if (!this.selectedSlots.isEmpty()) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    StringBuilder slotList = new StringBuilder();
                    for (int i : this.selectedSlots) {
                        if (slotList.length() > 0) {
                            slotList.append(",");
                        }
                        slotList.append(i);
                        IItemHandler patt0$temp = ((CrazyPhonePicturesScreenMenu)this.menu).internal;
                        if (!(patt0$temp instanceof CrazyPhonePicturesScreenMenu.AlbumInventoryItemHandler)) continue;
                        CrazyPhonePicturesScreenMenu.AlbumInventoryItemHandler handler = (CrazyPhonePicturesScreenMenu.AlbumInventoryItemHandler)patt0$temp;
                        handler.albumInventory.setItem(i, ItemStack.EMPTY);
                    }
                    values.put("selectedSlots", slotList.toString());
                    values.put("albumIndex", String.valueOf(this.albumId));
                    PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhonePicturesScreenButtonMessage(0, this.x, this.y, this.z, values), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    CrazyPhoneHelper.deleteSelectedAlbumSlotsFromHeldPhone(this.entity, this.world, this.selectedSlots, this.albumId);
                }
                this.selectedSlots.clear();
                Minecraft.getInstance().player.playSound(SoundEvents.ITEM_BREAK, 1.0f, 1.0f);
            }).bounds(this.leftPos + 62, this.topPos + 154, 54, 20).build();
            guistate.put("button:button_del", this.button_del);
            this.addRenderableWidget((GuiEventListener)this.button_del);
            this.button_take = Button.builder((Component)Component.translatable((String)"gui.crazythings.crazy_phone_pictures_screen.button_take"), e -> {
                if (!this.selectedSlots.isEmpty()) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    StringBuilder slotList = new StringBuilder();
                    for (int i : this.selectedSlots) {
                        if (slotList.length() > 0) {
                            slotList.append(",");
                        }
                        slotList.append(i);
                    }
                    values.put("selectedSlots", slotList.toString());
                    values.put("albumIndex", String.valueOf(this.albumId));
                    PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhonePicturesScreenButtonMessage(1, this.x, this.y, this.z, values), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    Minecraft.getInstance().player.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
                }
                this.selectedSlots.clear();
            }).bounds(this.leftPos + 6, this.topPos + 154, 54, 20).build();
            guistate.put("button:button_take", this.button_take);
            this.addRenderableWidget((GuiEventListener)this.button_take);
        }
    }

    private void playToggleSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }
}

