/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import java.util.HashMap;
import net.mcreator.crazythings.client.gui.CrazyPhoneDefaultScreenScreen;
import net.mcreator.crazythings.client.gui.components.PasswordEditBox;
import net.mcreator.crazythings.network.CrazyPhonePasswordScreenButtonMessage;
import net.mcreator.crazythings.procedures.CrazyPhoneGetInitialFormValidationMessageProcedure;
import net.mcreator.crazythings.procedures.GetCrazyPhoneNumberFromMainHandProcedure;
import net.mcreator.crazythings.world.inventory.CrazyPhonePasswordScreenMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyPhonePasswordScreenScreen
extends CrazyPhoneDefaultScreenScreen<CrazyPhonePasswordScreenMenu> {
    private static final HashMap<String, Object> guistate = CrazyPhonePasswordScreenMenu.guistate;
    private EditBox number;
    private EditBox name;
    private EditBox password;
    private Button buttonValider;
    private ImageButton buttonReset;

    public CrazyPhonePasswordScreenScreen(CrazyPhonePasswordScreenMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
    }

    public static HashMap<String, String> getEditBoxAndCheckBoxValues() {
        HashMap<String, String> textstate = new HashMap<String, String>();
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CrazyPhonePasswordScreenScreen) {
            CrazyPhonePasswordScreenScreen sc = (CrazyPhonePasswordScreenScreen)screen;
            textstate.put("textin:number", sc.number.getValue());
            textstate.put("textin:name", sc.name.getValue());
            textstate.put("textin:password", sc.password.getValue());
        }
        return textstate;
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return guistate;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.number.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.name.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.password.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String numberVal = this.number.getValue();
        String nameVal = this.name.getValue();
        String passwordVal = this.password.getValue();
        super.resize(minecraft, width, height);
        this.number.setValue(numberVal);
        this.name.setValue(nameVal);
        this.password.setValue(passwordVal);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.label_numero_associe_au_telephone"), 8, 10, -12829636, false);
        guiGraphics.drawString(this.font, GetCrazyPhoneNumberFromMainHandProcedure.execute((Entity)this.entity, guistate), -153, -111, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.label_nom"), 8, 44, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.label_mot_de_passe"), 8, 79, -12829636, false);
        guiGraphics.drawString(this.font, CrazyPhoneGetInitialFormValidationMessageProcedure.execute((LevelAccessor)this.world, (Entity)this.entity, guistate), 8, 123, -12829636, false);
    }

    @Override
    public void init() {
        super.init();
        this.setBackButtonActive(false);
        this.setHomeButtonActive(false);
        this.setLockButtonActive(false);
        this.initNumberField();
        this.initNameField();
        this.initPasswordField();
        this.initValidateButton();
        this.initResetButton();
    }

    private void initNumberField() {
        this.number = new EditBox(this.font, this.leftPos + 8, this.topPos + 21, 83, 18, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.number"));
        this.number.setMaxLength(Short.MAX_VALUE);
        guistate.put("text:number", this.number);
        this.addWidget((GuiEventListener)this.number);
    }

    private void initNameField() {
        this.name = new EditBox(this, this.font, this.leftPos + 8, this.topPos + 55, 106, 18, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.name")){

            public void insertText(String text) {
                super.insertText(text);
                this.updateSuggestion();
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                this.updateSuggestion();
            }

            private void updateSuggestion() {
                this.setSuggestion(this.getValue().isEmpty() ? Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.name").getString() : null);
            }
        };
        this.name.setMaxLength(Short.MAX_VALUE);
        this.name.setSuggestion(Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.name").getString());
        guistate.put("text:name", this.name);
        this.addWidget((GuiEventListener)this.name);
    }

    private void initPasswordField() {
        this.password = new PasswordEditBox(this, this.font, this.leftPos + 8, this.topPos + 90, 106, 18, (Component)Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.password")){

            public void insertText(String text) {
                super.insertText(text);
                this.updateSuggestion();
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                this.updateSuggestion();
            }

            private void updateSuggestion() {
                this.setSuggestion(this.getValue().isEmpty() ? Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.password").getString() : null);
            }
        };
        this.password.setMaxLength(Short.MAX_VALUE);
        this.password.setSuggestion(Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.password").getString());
        guistate.put("text:password", this.password);
        this.addWidget((GuiEventListener)this.password);
    }

    private void initValidateButton() {
        this.buttonValider = Button.builder((Component)Component.translatable((String)"gui.crazythings.crazy_phone_password_screen.button_valider"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhonePasswordScreenButtonMessage(0, this.x, this.y, this.z, CrazyPhonePasswordScreenScreen.getEditBoxAndCheckBoxValues()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CrazyPhonePasswordScreenButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z, CrazyPhonePasswordScreenScreen.getEditBoxAndCheckBoxValues());
        }).bounds(this.leftPos + 31, this.topPos + 150, 61, 20).build();
        guistate.put("button:button_valider", this.buttonValider);
        this.addRenderableWidget((GuiEventListener)this.buttonValider);
    }

    private void initResetButton() {
        this.buttonReset = new ImageButton(this, this.leftPos + 96, this.topPos + 21, 18, 18, new WidgetSprites(ResourceLocation.parse((String)"crazythings:textures/screens/reset.png"), ResourceLocation.parse((String)"crazythings:textures/screens/reset.png")), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhonePasswordScreenButtonMessage(1, this.x, this.y, this.z, CrazyPhonePasswordScreenScreen.getEditBoxAndCheckBoxValues()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CrazyPhonePasswordScreenButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z, CrazyPhonePasswordScreenScreen.getEditBoxAndCheckBoxValues());
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:imagebutton_reset", this.buttonReset);
        this.addRenderableWidget((GuiEventListener)this.buttonReset);
    }
}

