/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crazythings.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.mcreator.crazythings.client.gui.CrazyPhoneDefaultScreenScreen;
import net.mcreator.crazythings.network.CrazyPhoneMayorsCandidatesButtonMessage;
import net.mcreator.crazythings.network.CrazythingsModVariables;
import net.mcreator.crazythings.utils.Contact;
import net.mcreator.crazythings.utils.CrazyPhoneHelper;
import net.mcreator.crazythings.world.inventory.CrazyPhoneMayorsCandidatesListMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrazyPhoneMayorsCandidatesListScreen
extends CrazyPhoneDefaultScreenScreen<CrazyPhoneMayorsCandidatesListMenu> {
    private static final HashMap<String, Object> guistate = CrazyPhoneMayorsCandidatesListMenu.guistate;
    private static final int SLOT_WIDTH = 18;
    private static final int SLOT_HEIGHT = 18;
    private final List<RenderSlot> renderSlots = new ArrayList<RenderSlot>();

    public CrazyPhoneMayorsCandidatesListScreen(CrazyPhoneMayorsCandidatesListMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
        this.buildRenderList();
    }

    private void buildRenderList() {
        this.renderSlots.clear();
        CrazythingsModVariables.MapVariables variables = CrazythingsModVariables.MapVariables.get((LevelAccessor)this.entity.level());
        CompoundTag candidates = variables.mayorsCandidates;
        CompoundTag phones = variables.phones;
        ArrayList keys = new ArrayList(candidates.getAllKeys());
        int startX = 7;
        int startY = 11;
        for (int i = 0; i < keys.size(); ++i) {
            String number = (String)keys.get(i);
            CompoundTag phoneData = phones.getCompound(number);
            String name = phoneData.getString("name");
            String skin = phoneData.getString("skin");
            String uuid = phoneData.getString("uuid");
            Contact contact = new Contact(number, name);
            if (!uuid.isEmpty()) {
                contact.setUuid(uuid);
            }
            if (!skin.isEmpty()) {
                contact.setSkin(skin);
            }
            ItemStack head = CrazyPhoneHelper.createContactHead(contact);
            int x = startX + i % 6 * 18;
            int y = startY + i / 6 * 18;
            this.renderSlots.add(new RenderSlot(x, y, head));
        }
    }

    @Override
    public HashMap<String, Object> getWidgets() {
        return guistate;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (RenderSlot rs : this.renderSlots) {
            int iconX = this.leftPos + rs.x;
            int iconY = this.topPos + rs.y;
            guiGraphics.renderItem(rs.stack, iconX, iconY);
            if (!this.isHovering(rs, mouseX, mouseY)) continue;
            guiGraphics.fill(iconX, iconY, iconX + 16, iconY + 16, -2130706433);
            guiGraphics.renderTooltip(this.font, rs.stack, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        HashMap<String, String> textstate = CrazyPhoneMayorsCandidatesListScreen.getEditBoxAndCheckBoxValues();
        for (RenderSlot rs : this.renderSlots) {
            if (!this.isHovering(rs, mouseX, mouseY)) continue;
            String candidateNumber = ((CustomData)rs.stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("number");
            textstate.put("candidateNumber", candidateNumber);
            PacketDistributor.sendToServer((CustomPacketPayload)new CrazyPhoneMayorsCandidatesButtonMessage(0, this.x, this.y, this.z, textstate), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CrazyPhoneMayorsCandidatesButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z, textstate);
            break;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isHovering(RenderSlot rs, double mouseX, double mouseY) {
        int slotX = this.leftPos + rs.x;
        int slotY = this.topPos + rs.y;
        return mouseX >= (double)slotX && mouseX < (double)(slotX + 16) && mouseY >= (double)slotY && mouseY < (double)(slotY + 16);
    }

    @Override
    public void init() {
        super.init();
    }

    private static class RenderSlot {
        final int x;
        final int y;
        final ItemStack stack;

        RenderSlot(int x, int y, ItemStack stack) {
            this.x = x;
            this.y = y;
            this.stack = stack;
        }
    }
}

